/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.dv.xs;

import com.sun.org.apache.xerces.internal.impl.dv.InvalidDatatypeValueException;
import com.sun.org.apache.xerces.internal.impl.dv.ValidationContext;
import com.sun.org.apache.xerces.internal.impl.dv.util.ByteListImpl;
import com.sun.org.apache.xerces.internal.impl.dv.util.HexBin;
import com.sun.org.apache.xerces.internal.impl.dv.xs.TypeValidator;

public class HexBinaryDV
extends TypeValidator {
    public short getAllowedFacets() {
        return 2079;
    }

    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        byte[] decoded = HexBin.decode(content);
        if (decoded == null) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "hexBinary"});
        }
        return new XHex(decoded);
    }

    public int getDataLength(Object value) {
        return ((XHex)value).getLength();
    }

    private static final class XHex
    extends ByteListImpl {
        public XHex(byte[] data) {
            super(data);
        }

        public synchronized String toString() {
            if (this.canonical == null) {
                this.canonical = HexBin.encode(this.data);
            }
            return this.canonical;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof XHex)) {
                return false;
            }
            int len = this.data.length;
            byte[] odata = ((XHex)obj).data;
            if (len != odata.length) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if (this.data[i] == odata[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hash = 0;
            for (int i = 0; i < this.data.length; ++i) {
                hash = hash * 37 + (this.data[i] & 0xFF);
            }
            return hash;
        }
    }
}

