/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

final class ObjectToObjectConverter
implements ConditionalGenericConverter {
    ObjectToObjectConverter() {
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (sourceType.getType().equals(targetType.getType())) {
            return false;
        }
        return String.class.equals(targetType.getType()) ? ClassUtils.getConstructorIfAvailable(String.class, sourceType.getType()) != null : ObjectToObjectConverter.hasToMethodOrOfMethodOrConstructor(targetType.getType(), sourceType.getType());
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        Class<?> sourceClass = sourceType.getType();
        Class<?> targetClass = targetType.getType();
        try {
            Constructor<?> constructor;
            if (!String.class.equals(targetClass)) {
                Method method = ObjectToObjectConverter.getToMethod(targetClass, sourceClass);
                if (method != null) {
                    ReflectionUtils.makeAccessible(method);
                    return method.invoke(source, new Object[0]);
                }
                method = ObjectToObjectConverter.getOfMethod(targetClass, sourceClass);
                if (method != null) {
                    ReflectionUtils.makeAccessible(method);
                    return method.invoke(null, source);
                }
            }
            if ((constructor = ClassUtils.getConstructorIfAvailable(targetClass, sourceClass)) != null) {
                return constructor.newInstance(source);
            }
        }
        catch (InvocationTargetException ex) {
            throw new ConversionFailedException(sourceType, targetType, source, ex.getTargetException());
        }
        catch (Throwable ex) {
            throw new ConversionFailedException(sourceType, targetType, source, ex);
        }
        throw new IllegalStateException("No static valueOf/of/from(" + sourceClass.getName() + ") method or Constructor(" + sourceClass.getName() + ") exists on " + targetClass.getName());
    }

    private static boolean hasToMethodOrOfMethodOrConstructor(Class<?> targetClass, Class<?> sourceClass) {
        return ObjectToObjectConverter.getToMethod(targetClass, sourceClass) != null || ObjectToObjectConverter.getOfMethod(targetClass, sourceClass) != null || ClassUtils.getConstructorIfAvailable(targetClass, sourceClass) != null;
    }

    private static Method getToMethod(Class<?> targetClass, Class<?> sourceClass) {
        Method method = ClassUtils.getMethodIfAvailable(sourceClass, "to" + targetClass.getSimpleName(), new Class[0]);
        return method != null && targetClass.equals(method.getReturnType()) ? method : null;
    }

    static Method getOfMethod(Class<?> targetClass, Class<?> sourceClass) {
        Method method = ClassUtils.getStaticMethod(targetClass, "valueOf", sourceClass);
        if (method == null && (method = ClassUtils.getStaticMethod(targetClass, "of", sourceClass)) == null) {
            method = ClassUtils.getStaticMethod(targetClass, "from", sourceClass);
        }
        return method;
    }
}

