/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.task;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.apache.servicecomb.serviceregistry.task.AbstractRegisterTask;
import org.apache.servicecomb.serviceregistry.task.MicroserviceRegisterTask;
import org.apache.servicecomb.serviceregistry.task.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MicroserviceInstanceRegisterTask
extends AbstractRegisterTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceInstanceRegisterTask.class);
    private ServiceRegistryConfig serviceRegistryConfig;
    private MicroserviceInstance microserviceInstance;

    public MicroserviceInstanceRegisterTask(EventBus eventBus, ServiceRegistryConfig serviceRegistryConfig, ServiceRegistryClient srClient, Microservice microservice) {
        super(eventBus, srClient, microservice);
        this.serviceRegistryConfig = serviceRegistryConfig;
        this.microserviceInstance = microservice.getInstance();
    }

    @Subscribe
    public void onMicroserviceRegisterTask(MicroserviceRegisterTask task) {
        if (task.taskStatus == TaskStatus.FINISHED && this.isSameMicroservice(task.getMicroservice())) {
            this.taskStatus = TaskStatus.READY;
            this.registered = false;
        } else {
            this.taskStatus = TaskStatus.INIT;
        }
    }

    @Override
    protected boolean doRegister() {
        LOGGER.info("running microservice instance register task.");
        String hostName = "";
        hostName = this.serviceRegistryConfig.isPreferIpAddress() ? RegistryUtils.getPublishAddress() : RegistryUtils.getPublishHostName();
        this.microserviceInstance.setHostName(hostName);
        this.microserviceInstance.getHealthCheck().setInterval(this.serviceRegistryConfig.getHeartbeatInterval());
        this.microserviceInstance.getHealthCheck().setTimes(this.serviceRegistryConfig.getResendHeartBeatTimes());
        String instanceId = this.srClient.registerMicroserviceInstance(this.microserviceInstance);
        if (StringUtils.isEmpty((Object)instanceId)) {
            LOGGER.error("Register microservice instance failed,will back to register microservice again. microserviceId={}", (Object)this.microserviceInstance.getServiceId());
            return false;
        }
        this.microserviceInstance.setInstanceId(instanceId);
        LOGGER.info("Register microservice instance success. microserviceId={} instanceId={} endpoints={} lease {}s", new Object[]{this.microserviceInstance.getServiceId(), instanceId, this.microserviceInstance.getEndpoints(), this.microserviceInstance.getHealthCheck().getTTL()});
        return true;
    }
}

