/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.compatibility.validators.parameter;

import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffValidationContext;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffViolation;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasObjectDiffValidatorTemplate;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.ParameterDiffValidator;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.util.ParameterUtils;

public class ParameterAddDiffValidator
extends OasObjectDiffValidatorTemplate<Parameter>
implements ParameterDiffValidator {
    public static final String VIOLATION_MESSAGE = "required=true parameter is not allowed on right side";

    protected List<OasDiffViolation> validateAdd(OasDiffValidationContext context, OasObjectPropertyLocation rightLocation, Parameter rightOasObject) {
        if (Boolean.FALSE.equals(rightOasObject.getRequired())) {
            return Collections.emptyList();
        }
        String message = ParameterUtils.getKeyString((Parameter)rightOasObject) + ':' + VIOLATION_MESSAGE;
        return Collections.singletonList(OasDiffViolation.onlyRight((OasObjectPropertyLocation)rightLocation.property("required"), (String)message));
    }
}

