/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.generator.annotation;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.servicecomb.toolkit.generator.annotation.MethodAnnotationProcessor;
import org.apache.servicecomb.toolkit.generator.context.OperationContext;
import org.apache.servicecomb.toolkit.generator.util.SwaggerAnnotationUtils;

public class OperationMethodAnnotationProcessor
implements MethodAnnotationProcessor<Operation, OperationContext> {
    @Override
    public void process(Operation annotation, OperationContext context) {
        context.setOperationId(annotation.operationId());
        context.setDeprecated(annotation.deprecated());
        context.setDescription(annotation.description());
        Map<String, Object> extensionsFromAnnotation = SwaggerAnnotationUtils.getExtensionsFromAnnotation(annotation.extensions());
        Optional.ofNullable(extensionsFromAnnotation).ifPresent(extensions -> extensions.forEach(context::addExtension));
        ApiResponse[] responses = annotation.responses();
        MethodAnnotationProcessor apiResponseAnnotationProcessor = context.getParser().findMethodAnnotationProcessor(ApiResponse.class);
        for (ApiResponse response : responses) {
            Optional.ofNullable(apiResponseAnnotationProcessor).ifPresent(processor -> processor.process(response, context));
        }
        context.setHttpMethod(annotation.method());
        context.setSummary(annotation.summary());
        Arrays.stream(annotation.tags()).forEach(context::addTag);
    }
}

