/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.cli;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.toolkit.CodeGenerator;
import org.apache.servicecomb.toolkit.GeneratorFactory;
import org.openapitools.codegen.config.CodegenConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="codegenerate", description="Generate multiple models of microservice project by OpenAPI specification file")
public class CodeGenerate
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeGenerate.class);
    @Option(name={"-p", "--programming-model"}, title="programming model", required=false, description="programming model, as SpringMVC, POJO, JAX-RS, and SpringBoot")
    private String programmingModel;
    @Option(name={"-m", "--microservice-framework"}, title="framework", description="microservice-framework")
    private String framework = "ServiceComb";
    @Option(name={"-i", "--input"}, title="OpenAPI specification file", required=true, description="location of the OpenAPI specification file, as URL or file (required)")
    private String specFile;
    @Option(name={"-o", "--output"}, title="output directory", description="location of the generated document (current dir by default)")
    private String output = "";
    @Option(name={"--group-id"}, title="group id", description="groupId in generated microservice project")
    private String groupId;
    @Option(name={"--artifact-id"}, title="artifact id", description="artifact id in generated microservice project")
    private String artifactId;
    @Option(name={"--artifact-version"}, title="artifact version", description="artifact version in generated microservice project")
    private String artifactVersion;
    @Option(name={"--api-package"}, title="api package", description="api package in generated microservice project")
    private String apiPackage;
    @Option(name={"--model-package"}, title="model package", description="model package in generated microservice project")
    private String modelPackage;
    @Option(name={"-t", "--service-type"}, title="service type", description="microservice type of generated microservice project. optional value is provider,consumer,all")
    private String serviceType = "all";
    @Option(name={"--properties"}, title="additional properties", description="usage: --properties name=value,name=value. These Properties can be referenced by the mustache templates. You can specify one or more value")
    private String properties;

    @Override
    public void run() {
        CodeGenerator codegenerator = (CodeGenerator)GeneratorFactory.getGenerator(CodeGenerator.class, (String)"default");
        if (codegenerator == null) {
            LOGGER.warn("Not CodeGenerator found");
            return;
        }
        CodegenConfigurator configurator = new CodegenConfigurator();
        Optional.ofNullable(this.properties).ifPresent(properties -> Arrays.stream(properties.split(",")).forEach(property -> {
            String[] split = property.split("=");
            if (split != null && split.length == 2) {
                configurator.addAdditionalProperty(split[0], (Object)split[1]);
            }
        }));
        configurator.setOutputDir(this.output).setGroupId(this.groupId).setArtifactId(this.artifactId).setArtifactVersion(this.artifactVersion).setLibrary(this.programmingModel).setGeneratorName(this.framework).setApiPackage(this.apiPackage).setModelPackage(this.modelPackage);
        configurator.addAdditionalProperty("serviceType", (Object)this.serviceType);
        if (StringUtils.isNotEmpty((CharSequence)this.specFile)) {
            File contractFile = new File(this.specFile);
            if (contractFile.isDirectory()) {
                try {
                    Files.walkFileTree(Paths.get(contractFile.toURI()), (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
                }
                catch (IOException | RuntimeException e) {
                    LOGGER.error(e.getMessage());
                    return;
                }
            } else {
                configurator.setInputSpec(this.specFile).addAdditionalProperty("apiName", (Object)contractFile.getName().split("\\.")[0]);
                codegenerator.configure(Collections.singletonMap("configurator", configurator));
                codegenerator.generate();
            }
            LOGGER.info("Success to generate code, the directory is: {}", (Object)this.output);
        }
    }
}

