/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.common.utils.JvmUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.TargetClassAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class BeanUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanUtils.class);
    public static final String DEFAULT_BEAN_RESOURCE = "classpath*:META-INF/spring/*.bean.xml";
    public static final String SCB_SCAN_PACKAGE = "scb-scan-package";
    private static final String SCB_PACKAGE = "org.apache.servicecomb";
    private static ApplicationContext context;

    private BeanUtils() {
    }

    public static void init() {
        BeanUtils.init(DEFAULT_BEAN_RESOURCE);
    }

    public static void init(String ... configLocations) {
        BeanUtils.prepareServiceCombScanPackage();
        context = new ClassPathXmlApplicationContext(configLocations);
    }

    private static void addItem(Set<String> set, String item) {
        for (String it : set) {
            if (!item.startsWith(it)) continue;
            return;
        }
        set.add(item);
    }

    public static void prepareServiceCombScanPackage() {
        LinkedHashSet<String> scanPackags = new LinkedHashSet<String>();
        String exists = System.getProperty(SCB_SCAN_PACKAGE);
        if (exists != null) {
            for (String exist : exists.trim().split(",")) {
                if (exist.isEmpty()) continue;
                BeanUtils.addItem(scanPackags, exist.trim());
            }
        }
        BeanUtils.addItem(scanPackags, SCB_PACKAGE);
        for (Class mainClass : new Class[]{JvmUtils.findMainClass(), JvmUtils.findMainClassByStackTrace()}) {
            if (mainClass == null) continue;
            String pkg = mainClass.getPackage().getName();
            BeanUtils.addItem(scanPackags, pkg);
        }
        String scbScanPackages = StringUtils.join(scanPackags, (String)",");
        System.setProperty(SCB_SCAN_PACKAGE, scbScanPackages);
        LOGGER.info("Scb scan package list: " + scbScanPackages);
    }

    public static ApplicationContext getContext() {
        return context;
    }

    public static void setContext(ApplicationContext applicationContext) {
        context = applicationContext;
    }

    public static <T> T getBean(String name) {
        return (T)context.getBean(name);
    }

    public static Class<?> getImplClassFromBean(Object bean) {
        if (TargetClassAware.class.isInstance(bean)) {
            return ((TargetClassAware)bean).getTargetClass();
        }
        return bean.getClass();
    }
}

