/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.logging.ch.qos.logback.classic.servlet;

import java.util.EventListener;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.rocketmq.logging.ch.qos.logback.classic.servlet.LogbackServletContextListener;
import org.apache.rocketmq.logging.ch.qos.logback.classic.util.StatusViaSLF4JLoggerFactory;
import org.apache.rocketmq.logging.ch.qos.logback.core.util.OptionHelper;

public class LogbackServletContainerInitializer
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        if (this.isDisabledByConfiguration(ctx)) {
            StatusViaSLF4JLoggerFactory.addInfo("Due to deployment instructions will NOT register an instance of " + LogbackServletContextListener.class + " to the current web-app", this);
            return;
        }
        StatusViaSLF4JLoggerFactory.addInfo("Adding an instance of  " + LogbackServletContextListener.class + " to the current web-app", this);
        LogbackServletContextListener lscl = new LogbackServletContextListener();
        ctx.addListener((EventListener)((Object)lscl));
    }

    boolean isDisabledByConfiguration(ServletContext ctx) {
        String disableAttributeStr = null;
        String disableAttribute = ctx.getInitParameter("logbackDisableServletContainerInitializer");
        if (disableAttribute instanceof String) {
            disableAttributeStr = disableAttribute;
        }
        if (OptionHelper.isNullOrEmpty(disableAttributeStr)) {
            disableAttributeStr = OptionHelper.getSystemProperty("logbackDisableServletContainerInitializer");
        }
        if (OptionHelper.isNullOrEmpty(disableAttributeStr)) {
            disableAttributeStr = OptionHelper.getEnv("logbackDisableServletContainerInitializer");
        }
        return Boolean.parseBoolean(disableAttributeStr);
    }
}

