/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectAttribute;
import org.apache.qpid.server.model.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredObjectToMapConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfiguredObjectToMapConverter.class);
    private static final Set<String> CONFIG_EXCLUDED_ATTRIBUTES = new HashSet<String>(Arrays.asList("id", "durable", "createdBy", "createdTime", "lastUpdatedBy", "lastUpdatedTime"));
    public static final String STATISTICS_MAP_KEY = "statistics";

    public Map<String, Object> convertObjectToMap(ConfiguredObject<?> confObject, Class<? extends ConfiguredObject> clazz, ConverterOptions converterOptions) {
        LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>();
        this.incorporateAttributesIntoMap(confObject, object, converterOptions);
        this.incorporateStatisticsIntoMap(confObject, object);
        if (converterOptions.getDepth() > 0) {
            this.incorporateChildrenIntoMap(confObject, clazz, object, converterOptions);
        }
        return object;
    }

    private void incorporateAttributesIntoMap(ConfiguredObject<?> confObject, Map<String, Object> object, ConverterOptions converterOptions) {
        for (String name : confObject.getAttributeNames()) {
            Object value;
            Object object2 = value = converterOptions.isUseActualValues() ? confObject.getActualAttributes().get(name) : confObject.getAttribute(name);
            if (value instanceof ConfiguredObject) {
                object.put(name, ((ConfiguredObject)value).getName());
                continue;
            }
            if ("context".equals(name)) {
                Map<String, Object> contextValues = this.collectContext(confObject, converterOptions.isExcludeInheritedContext(), converterOptions.isUseActualValues());
                if (contextValues.isEmpty()) continue;
                object.put("context", contextValues);
                continue;
            }
            if (value instanceof Collection) {
                ArrayList<String> converted = new ArrayList<String>();
                for (Object member : (Collection)value) {
                    if (member instanceof ConfiguredObject) {
                        converted.add(((ConfiguredObject)member).getName());
                        continue;
                    }
                    converted.add((String)member);
                }
                object.put(name, converted);
                continue;
            }
            if (value instanceof Named) {
                object.put(name, ((Named)value).getName());
                continue;
            }
            if (value == null) continue;
            ConfiguredObjectAttribute attribute = (ConfiguredObjectAttribute)confObject.getModel().getTypeRegistry().getAttributeTypes(confObject.getClass()).get(name);
            if (attribute.isSecureValue(value)) {
                value = confObject.getAttribute(name);
            }
            if (attribute.isOversized() && !converterOptions.isUseActualValues()) {
                String valueString = String.valueOf(value);
                if (valueString.length() > converterOptions.getOversizeThreshold()) {
                    String replacementValue = "".equals(attribute.getOversizedAltText()) ? String.valueOf(value).substring(0, converterOptions.getOversizeThreshold() - 4) + "..." : attribute.getOversizedAltText();
                    object.put(name, replacementValue);
                    continue;
                }
                object.put(name, value);
                continue;
            }
            object.put(name, value);
        }
    }

    private Map<String, Object> collectContext(ConfiguredObject<?> configuredObject, boolean excludeInheritedContext, boolean useActualValues) {
        HashMap<String, Object> actualContext = new HashMap<String, Object>();
        if (excludeInheritedContext) {
            Object value = configuredObject.getActualAttributes().get("context");
            if (value instanceof Map) {
                actualContext.putAll((Map)value);
            }
        } else {
            actualContext.putAll(configuredObject.getModel().getTypeRegistry().getDefaultContext());
            actualContext.putAll(System.getenv());
            actualContext.putAll(System.getProperties());
            this.collectInheritedActualContext(configuredObject, actualContext);
        }
        if (useActualValues) {
            return actualContext;
        }
        HashMap<String, Object> effectiveContext = new HashMap<String, Object>();
        for (String contextKey : actualContext.keySet()) {
            effectiveContext.put(contextKey, configuredObject.getContextValue(String.class, contextKey));
        }
        return effectiveContext;
    }

    private void collectInheritedActualContext(ConfiguredObject<?> confObject, Map<String, Object> contextValues) {
        Object value;
        ConfiguredObject parent = confObject.getParent();
        if (parent != null) {
            this.collectInheritedActualContext(parent, contextValues);
        }
        if ((value = confObject.getActualAttributes().get("context")) instanceof Map) {
            contextValues.putAll((Map)value);
        }
    }

    private void incorporateStatisticsIntoMap(ConfiguredObject<?> confObject, Map<String, Object> object) {
        TreeMap statMap = new TreeMap(confObject.getStatistics());
        if (!statMap.isEmpty()) {
            object.put(STATISTICS_MAP_KEY, statMap);
        }
    }

    private void incorporateChildrenIntoMap(ConfiguredObject confObject, Class<? extends ConfiguredObject> clazz, Map<String, Object> object, ConverterOptions converterOptions) {
        ArrayList<Class> childTypes = new ArrayList<Class>(confObject.getModel().getChildTypes(clazz));
        childTypes.sort(Comparator.comparing(Class::getSimpleName));
        ConverterOptions childConverterOptions = new ConverterOptions(converterOptions, converterOptions.getDepth() - 1);
        for (Class childClass : childTypes) {
            String childTypeSingular;
            Collection children = confObject.getChildren(childClass);
            if (children == null) continue;
            ArrayList<ConfiguredObject> sortedChildren = new ArrayList<ConfiguredObject>(children);
            if (Comparable.class.isAssignableFrom(childClass)) {
                Collections.sort(sortedChildren);
            } else {
                sortedChildren.sort(Comparator.comparing(o -> o.getName()));
            }
            ArrayList<Map<String, Object>> childObjects = new ArrayList<Map<String, Object>>();
            for (ConfiguredObject child : sortedChildren) {
                childObjects.add(this.convertObjectToMap(child, childClass, childConverterOptions));
            }
            if (childObjects.isEmpty()) continue;
            object.put(childTypeSingular + ((childTypeSingular = childClass.getSimpleName().toLowerCase()).endsWith("s") ? "es" : "s"), childObjects);
        }
    }

    public static final class ConverterOptions {
        private final int _depth;
        private final boolean _useActualValues;
        private final int _oversizeThreshold;
        private final boolean _secureTransport;
        private final boolean _excludeInheritedContext;

        public ConverterOptions(ConverterOptions options, int depth) {
            this(depth, options.isUseActualValues(), options.getOversizeThreshold(), options.isSecureTransport(), options.isExcludeInheritedContext());
        }

        public ConverterOptions(int depth, boolean useActualValues, int oversizeThreshold, boolean secureTransport, boolean excludeInheritedContext) {
            this._depth = depth;
            this._useActualValues = useActualValues;
            this._oversizeThreshold = oversizeThreshold;
            this._secureTransport = secureTransport;
            this._excludeInheritedContext = excludeInheritedContext;
        }

        public int getDepth() {
            return this._depth;
        }

        public boolean isUseActualValues() {
            return this._useActualValues;
        }

        public int getOversizeThreshold() {
            return this._oversizeThreshold;
        }

        public boolean isSecureTransport() {
            return this._secureTransport;
        }

        public boolean isExcludeInheritedContext() {
            return this._excludeInheritedContext;
        }
    }
}

