/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.edm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.Association;
import org.apache.olingo.odata2.api.edm.provider.AssociationSet;
import org.apache.olingo.odata2.api.edm.provider.AssociationSetEnd;
import org.apache.olingo.odata2.api.edm.provider.ComplexType;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.edm.provider.EntityContainer;
import org.apache.olingo.odata2.api.edm.provider.EntityContainerInfo;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.api.edm.provider.FunctionImport;
import org.apache.olingo.odata2.api.edm.provider.Schema;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.factory.ODataJPAFactory;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmModelView;

public class ODataJPAEdmProvider
extends EdmProvider {
    private ODataJPAContext oDataJPAContext;
    private JPAEdmModelView jpaEdmModel;
    private List<Schema> schemas;
    private HashMap<String, EntityType> entityTypes;
    private HashMap<String, EntityContainerInfo> entityContainerInfos;
    private HashMap<String, ComplexType> complexTypes;
    private HashMap<String, Association> associations;
    private HashMap<String, FunctionImport> functionImports;

    public ODataJPAEdmProvider() {
        this.entityTypes = new LinkedHashMap<String, EntityType>();
        this.entityContainerInfos = new LinkedHashMap<String, EntityContainerInfo>();
        this.complexTypes = new LinkedHashMap<String, ComplexType>();
        this.associations = new LinkedHashMap<String, Association>();
        this.functionImports = new LinkedHashMap<String, FunctionImport>();
    }

    public ODataJPAEdmProvider(ODataJPAContext oDataJPAContext) {
        if (oDataJPAContext == null) {
            throw new IllegalArgumentException("OData JPA Context cannot be null");
        }
        this.entityTypes = new LinkedHashMap<String, EntityType>();
        this.entityContainerInfos = new LinkedHashMap<String, EntityContainerInfo>();
        this.complexTypes = new LinkedHashMap<String, ComplexType>();
        this.associations = new LinkedHashMap<String, Association>();
        this.functionImports = new LinkedHashMap<String, FunctionImport>();
        this.jpaEdmModel = ODataJPAFactory.createFactory().getJPAAccessFactory().getJPAEdmModelView(oDataJPAContext);
    }

    public ODataJPAContext getODataJPAContext() {
        return this.oDataJPAContext;
    }

    public void setODataJPAContext(ODataJPAContext jpaContext) {
        this.oDataJPAContext = jpaContext;
    }

    public EntityContainerInfo getEntityContainerInfo(String name) throws ODataException {
        List containerList;
        if (this.entityContainerInfos.containsKey(name)) {
            return this.entityContainerInfos.get(name);
        }
        if (this.schemas == null) {
            this.getSchemas();
        }
        if ((containerList = this.schemas.get(0).getEntityContainers()) == null) {
            return null;
        }
        for (EntityContainer container : containerList) {
            if (name == null && container.isDefaultEntityContainer()) {
                this.entityContainerInfos.put(name, (EntityContainerInfo)container);
                return container;
            }
            if (name == null || !name.equals(container.getName())) continue;
            return container;
        }
        return null;
    }

    public EntityType getEntityType(FullQualifiedName edmFQName) throws ODataException {
        String strEdmFQName = null;
        if (edmFQName != null) {
            strEdmFQName = edmFQName.toString();
            if (this.entityTypes.containsKey(strEdmFQName)) {
                return this.entityTypes.get(strEdmFQName);
            }
            if (this.schemas == null) {
                this.getSchemas();
            }
            String entityTypeNamespace = edmFQName.getNamespace();
            String entityTypeName = edmFQName.getName();
            for (Schema schema : this.schemas) {
                String schemaNamespace = schema.getNamespace();
                if (!schemaNamespace.equals(entityTypeNamespace)) continue;
                if (schema.getEntityTypes() == null) {
                    return null;
                }
                for (EntityType et : schema.getEntityTypes()) {
                    if (!et.getName().equals(entityTypeName)) continue;
                    this.entityTypes.put(strEdmFQName, et);
                    return et;
                }
            }
        }
        return null;
    }

    public ComplexType getComplexType(FullQualifiedName edmFQName) throws ODataException {
        if (edmFQName != null) {
            if (this.complexTypes.containsKey(edmFQName.toString())) {
                return this.complexTypes.get(edmFQName.toString());
            }
            if (this.schemas == null) {
                this.getSchemas();
            }
            for (Schema schema : this.schemas) {
                if (!schema.getNamespace().equals(edmFQName.getNamespace())) continue;
                if (schema.getComplexTypes() == null) {
                    return null;
                }
                for (ComplexType ct : schema.getComplexTypes()) {
                    if (!ct.getName().equals(edmFQName.getName())) continue;
                    this.complexTypes.put(edmFQName.toString(), ct);
                    return ct;
                }
            }
        }
        return null;
    }

    public Association getAssociation(FullQualifiedName edmFQName) throws ODataException {
        if (edmFQName != null) {
            if (this.associations.containsKey(edmFQName.toString())) {
                return this.associations.get(edmFQName.toString());
            }
            if (this.schemas == null) {
                this.getSchemas();
            }
            for (Schema schema : this.schemas) {
                if (!schema.getNamespace().equals(edmFQName.getNamespace())) continue;
                if (schema.getAssociations() == null) {
                    return null;
                }
                for (Association association : schema.getAssociations()) {
                    if (!association.getName().equals(edmFQName.getName())) continue;
                    this.associations.put(edmFQName.toString(), association);
                    return association;
                }
            }
        }
        return null;
    }

    public EntitySet getEntitySet(String entityContainer, String name) throws ODataException {
        EntitySet returnedSet = null;
        EntityContainer container = null;
        container = !this.entityContainerInfos.containsKey(entityContainer) ? (EntityContainer)this.getEntityContainerInfo(entityContainer) : (EntityContainer)this.entityContainerInfos.get(entityContainer);
        if (container != null && name != null) {
            for (EntitySet es : container.getEntitySets()) {
                if (!name.equals(es.getName())) continue;
                returnedSet = es;
                break;
            }
        }
        return returnedSet;
    }

    public AssociationSet getAssociationSet(String entityContainer, FullQualifiedName association, String sourceEntitySetName, String sourceEntitySetRole) throws ODataException {
        EntityContainer container = null;
        container = !this.entityContainerInfos.containsKey(entityContainer) ? (EntityContainer)this.getEntityContainerInfo(entityContainer) : (EntityContainer)this.entityContainerInfos.get(entityContainer);
        if (container != null && association != null && container.getAssociationSets() != null) {
            for (AssociationSet as : container.getAssociationSets()) {
                if (!association.equals((Object)as.getAssociation())) continue;
                AssociationSetEnd end = as.getEnd1();
                if (sourceEntitySetName.equals(end.getEntitySet()) && sourceEntitySetRole.equals(end.getRole())) {
                    return as;
                }
                end = as.getEnd2();
                if (!sourceEntitySetName.equals(end.getEntitySet()) || !sourceEntitySetRole.equals(end.getRole())) continue;
                return as;
            }
        }
        return null;
    }

    public FunctionImport getFunctionImport(String entityContainer, String name) throws ODataException {
        if (this.functionImports.containsKey(name)) {
            return this.functionImports.get(name);
        }
        EntityContainer container = null;
        container = !this.entityContainerInfos.containsKey(entityContainer) ? (EntityContainer)this.getEntityContainerInfo(entityContainer) : (EntityContainer)this.entityContainerInfos.get(entityContainer);
        if (container != null && name != null) {
            if (container.getFunctionImports() == null) {
                return null;
            }
            for (FunctionImport fi : container.getFunctionImports()) {
                if (!name.equals(fi.getName())) continue;
                this.functionImports.put(name, fi);
                return fi;
            }
        }
        return null;
    }

    public List<Schema> getSchemas() throws ODataException {
        if (this.schemas == null && this.jpaEdmModel != null) {
            this.jpaEdmModel.getBuilder().build();
            this.schemas = new ArrayList<Schema>();
            this.schemas.add(this.jpaEdmModel.getEdmSchemaView().getEdmSchema());
        }
        if (this.jpaEdmModel == null) {
            throw ODataJPAModelException.throwException((MessageReference)ODataJPAModelException.BUILDER_NULL, null);
        }
        return this.schemas;
    }
}

