/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;
import org.apache.olingo.odata2.core.edm.Bit;
import org.apache.olingo.odata2.core.edm.EdmByte;
import org.apache.olingo.odata2.core.edm.EdmInt16;
import org.apache.olingo.odata2.core.edm.EdmInt32;
import org.apache.olingo.odata2.core.edm.EdmInt64;
import org.apache.olingo.odata2.core.edm.EdmSByte;
import org.apache.olingo.odata2.core.edm.EdmSingle;
import org.apache.olingo.odata2.core.edm.Uint7;

public class EdmDouble
extends AbstractSimpleType {
    private static final int MAX_PRECISION = 15;
    private static final int MAX_SCALE = 308;
    private static final Pattern PATTERN = Pattern.compile("(?:\\+|-)?\\p{Digit}+(?:\\.\\p{Digit}+)?(?:(?:E|e)(?:\\+|-)?\\p{Digit}{1,3})?(D|d)?");
    private static final EdmDouble instance = new EdmDouble();

    public static EdmDouble getInstance() {
        return instance;
    }

    @Override
    public boolean isCompatible(EdmSimpleType simpleType) {
        return simpleType instanceof Bit || simpleType instanceof Uint7 || simpleType instanceof EdmByte || simpleType instanceof EdmSByte || simpleType instanceof EdmInt16 || simpleType instanceof EdmInt32 || simpleType instanceof EdmInt64 || simpleType instanceof EdmSingle || simpleType instanceof EdmDouble;
    }

    public Class<?> getDefaultType() {
        return Double.class;
    }

    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        String valueString = value;
        Double result = null;
        if ("-INF".equals(value)) {
            result = Double.NEGATIVE_INFINITY;
        } else if ("INF".equals(value)) {
            result = Double.POSITIVE_INFINITY;
        } else if ("NaN".equals(value)) {
            result = Double.NaN;
        } else {
            Matcher matcher = PATTERN.matcher(value);
            if (!matcher.matches() || literalKind == EdmLiteralKind.URI == (matcher.group(1) == null)) {
                throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(new Object[]{value}));
            }
            if (literalKind == EdmLiteralKind.URI) {
                valueString = value.substring(0, value.length() - 1);
            }
            if ((result = Double.valueOf(valueString)).isInfinite()) {
                throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(new Object[]{value}));
            }
        }
        if (returnType.isAssignableFrom(Double.class)) {
            return returnType.cast(result);
        }
        if (returnType.isAssignableFrom(Float.class)) {
            if ((double)result.floatValue() == result) {
                return returnType.cast(Float.valueOf(result.floatValue()));
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_UNCONVERTIBLE_TO_VALUE_TYPE.addContent(new Object[]{value, returnType}));
        }
        if (result.isInfinite() || result.isNaN()) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_UNCONVERTIBLE_TO_VALUE_TYPE.addContent(new Object[]{value, returnType}));
        }
        try {
            BigDecimal valueBigDecimal = new BigDecimal(valueString);
            if (returnType.isAssignableFrom(BigDecimal.class)) {
                return returnType.cast(valueBigDecimal);
            }
            if (returnType.isAssignableFrom(Long.class)) {
                return returnType.cast(valueBigDecimal.longValueExact());
            }
            if (returnType.isAssignableFrom(Integer.class)) {
                return returnType.cast(valueBigDecimal.intValueExact());
            }
            if (returnType.isAssignableFrom(Short.class)) {
                return returnType.cast(valueBigDecimal.shortValueExact());
            }
            if (returnType.isAssignableFrom(Byte.class)) {
                return returnType.cast(valueBigDecimal.byteValueExact());
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(new Object[]{returnType}));
        }
        catch (ArithmeticException e) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_UNCONVERTIBLE_TO_VALUE_TYPE.addContent(new Object[]{value, returnType}), (Throwable)e);
        }
    }

    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        if (value instanceof Long) {
            if ((double)Math.abs((Long)value) < Math.pow(10.0, 15.0)) {
                return value.toString();
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_ILLEGAL_CONTENT.addContent(new Object[]{value}));
        }
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return value.toString();
        }
        if (value instanceof Double) {
            String result = value.toString();
            return ((Double)value).isInfinite() ? result.toUpperCase(Locale.ROOT).substring(0, value.toString().length() - 5) : result;
        }
        if (value instanceof Float) {
            String result = value.toString();
            return ((Float)value).isInfinite() ? result.toUpperCase(Locale.ROOT).substring(0, value.toString().length() - 5) : result;
        }
        if (value instanceof BigDecimal) {
            if (((BigDecimal)value).precision() <= 15 && Math.abs(((BigDecimal)value).scale()) <= 308) {
                return ((BigDecimal)value).toString();
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_ILLEGAL_CONTENT.addContent(new Object[]{value}));
        }
        throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(new Object[]{value.getClass()}));
    }

    @Override
    public String toUriLiteral(String literal) {
        return "-INF".equals(literal) || "INF".equals(literal) || "NaN".equals(literal) ? literal : literal + "D";
    }
}

