/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import javax.ws.rs.ext.RuntimeDelegate;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.namespace.QName;

public final class Link {
    public static final String TITLE = "title";
    public static final String REL = "rel";
    public static final String TYPE = "type";
    private URI uri;
    private Map<String, String> map = new HashMap<String, String>();
    private static final RuntimeDelegate.HeaderDelegate<Link> delegate = RuntimeDelegate.getInstance().createHeaderDelegate(Link.class);

    public URI getUri() {
        return this.uri;
    }

    public UriBuilder getUriBuilder() {
        return UriBuilder.fromUri(this.uri);
    }

    public String getRel() {
        return this.map.get(REL);
    }

    public String getTitle() {
        return this.map.get(TITLE);
    }

    public String getType() {
        return this.map.get(TYPE);
    }

    public Map<String, String> getParams() {
        return new HashMap<String, String>(this.map);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Link) {
            Link otherLink = (Link)other;
            return this.uri.equals(otherLink.uri) && ((Object)this.map).equals(otherLink.map);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + (this.uri != null ? this.uri.hashCode() : 0);
        hash = 89 * hash + (this.map != null ? ((Object)this.map).hashCode() : 0);
        return hash;
    }

    public String toString() {
        return delegate.toString(this);
    }

    public static Link valueOf(String value) throws IllegalArgumentException {
        return delegate.fromString(value);
    }

    public static Builder fromUri(URI uri) throws IllegalArgumentException {
        Builder b = new Builder();
        b.uri(uri);
        return b;
    }

    public static Builder fromUri(String uri) throws IllegalArgumentException {
        Builder b = new Builder();
        b.uri(uri);
        return b;
    }

    public static Builder fromLink(Link link) {
        Builder b = new Builder();
        b.uri(link.uri);
        ((Builder)b).link.map = new HashMap<String, String>(link.map);
        return b;
    }

    public static Builder fromResourceMethod(Class<?> resource, String method) throws IllegalArgumentException {
        return Link.fromResourceMethod(resource, method, method);
    }

    public static Builder fromResourceMethod(Class<?> resource, String method, String rel) throws IllegalArgumentException {
        Method[] methods;
        if (resource == null || method == null || rel == null) {
            throw new IllegalArgumentException("All parameters must be non-null");
        }
        Builder lb = Link.fromUri(UriBuilder.fromResource(resource).build(new Object[0]));
        lb.rel(rel);
        for (Method m : methods = resource.getMethods()) {
            String[] values;
            Produces ps;
            if (!m.getName().equals(method)) continue;
            Path path = m.getAnnotation(Path.class);
            if (path != null) {
                lb.path(m);
            }
            if ((ps = m.getAnnotation(Produces.class)) != null && (values = ps.value()).length > 0) {
                lb.type(values[0]);
            }
            return lb;
        }
        throw new IllegalArgumentException("Method '" + method + "' not found in class '" + resource.getName() + "'");
    }

    public static class JaxbAdapter
    extends XmlAdapter<JaxbLink, Link> {
        public Link unmarshal(JaxbLink v) throws Exception {
            Builder lb = Link.fromUri(v.getUri());
            for (Map.Entry<QName, Object> e : v.getParams().entrySet()) {
                lb.param(e.getKey().getLocalPart(), e.getValue().toString());
            }
            return lb.build();
        }

        public JaxbLink marshal(Link v) throws Exception {
            JaxbLink jl = new JaxbLink(v.getUri());
            for (Map.Entry<String, String> e : v.getParams().entrySet()) {
                String name = e.getKey();
                jl.getParams().put(new QName("", name), e.getValue());
            }
            return jl;
        }
    }

    public static class JaxbLink {
        private URI uri;
        private Map<QName, Object> params;

        public JaxbLink() {
        }

        public JaxbLink(URI uri) {
            this.uri = uri;
        }

        public JaxbLink(URI uri, Map<QName, Object> params) {
            this.uri = uri;
            this.params = params;
        }

        @XmlAttribute(name="href")
        public URI getUri() {
            return this.uri;
        }

        @XmlAnyAttribute
        public Map<QName, Object> getParams() {
            if (this.params == null) {
                this.params = new HashMap<QName, Object>();
            }
            return this.params;
        }
    }

    public static class Builder {
        private Link link = new Link();
        private UriBuilder uriBuilder;

        public Builder uri(URI uri) {
            this.uriBuilder = UriBuilder.fromUri(uri);
            return this;
        }

        public Builder uri(String uri) throws IllegalArgumentException {
            this.uriBuilder = UriBuilder.fromUri(uri);
            return this;
        }

        public Builder rel(String name) {
            this.param(Link.REL, name);
            return this;
        }

        public Builder title(String title) {
            this.param(Link.TITLE, title);
            return this;
        }

        public Builder type(String type) {
            this.param(Link.TYPE, type);
            return this;
        }

        public Builder param(String name, String value) throws IllegalArgumentException {
            if (name == null || value == null) {
                throw new IllegalArgumentException("Link parameter name or value is null");
            }
            this.link.map.put(name, value);
            return this;
        }

        public Link build() {
            this.link.uri = this.uriBuilder.build(new Object[0]);
            return this.link;
        }

        public Link build(Object ... values) throws UriBuilderException {
            this.link.uri = this.uriBuilder.build(values);
            return this.link;
        }

        private Builder path(Method method) {
            this.uriBuilder.path(method);
            return this;
        }
    }
}

