/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.component.SelectBooleanCommand;
import org.apache.myfaces.tobago.component.SelectOneCommand;
import org.apache.myfaces.tobago.component.SupportsAccessKey;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UIMenuSelectOne;
import org.apache.myfaces.tobago.component.UIToolBar;
import org.apache.myfaces.tobago.component.UIToolBarSeparator;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManager;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.component.AbstractUIMenu;
import org.apache.myfaces.tobago.internal.util.ObjectUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.Command;
import org.apache.myfaces.tobago.renderkit.html.CommandMap;
import org.apache.myfaces.tobago.renderkit.html.JsonUtils;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.util.SelectItemUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.CreateComponentUtils;
import org.apache.myfaces.tobago.util.FacetUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ToolBarRendererBase
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(ToolBarRendererBase.class);

    protected String getLabelPosition(UIComponent component) {
        return (String)component.getAttributes().get("labelPosition");
    }

    protected String getIconSize(UIComponent component) {
        return (String)component.getAttributes().get("iconSize");
    }

    protected boolean isRightAligned(UIToolBar toolBar) {
        return "right".equals(toolBar.getOrientation());
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        UIToolBar toolBar = (UIToolBar)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(context);
        Measure width = Measure.valueOf((int)-1);
        for (UIComponent command : toolBar.getChildren()) {
            if (command instanceof AbstractUICommand) {
                width = this.renderToolbarCommand(context, toolBar, (AbstractUICommand)command, writer, width);
                continue;
            }
            if (command instanceof UIToolBarSeparator) {
                width = this.renderSeparator(context, toolBar, (UIToolBarSeparator)command, writer, width);
                continue;
            }
            LOG.error("Illegal UIComponent class in toolbar (not a AbstractUICommand):" + command.getClass().getName());
        }
    }

    private Measure renderToolbarCommand(FacesContext facesContext, UIToolBar toolBar, AbstractUICommand command, TobagoResponseWriter writer, Measure width) throws IOException {
        if (command instanceof SelectBooleanCommand) {
            return this.renderSelectBoolean(facesContext, toolBar, command, writer, width);
        }
        if (command instanceof SelectOneCommand) {
            return this.renderSelectOne(facesContext, toolBar, command, writer, width);
        }
        if (command.getFacet("radio") != null) {
            return this.renderSelectOne(facesContext, toolBar, command, writer, width);
        }
        if (command.getFacet("checkbox") != null) {
            return this.renderSelectBoolean(facesContext, toolBar, command, writer, width);
        }
        CommandMap map = new CommandMap(new Command(facesContext, command));
        return this.renderToolbarButton(facesContext, toolBar, command, writer, false, width, map, null);
    }

    private Measure renderSelectOne(FacesContext facesContext, UIToolBar toolBar, AbstractUICommand command, TobagoResponseWriter writer, Measure width) throws IOException {
        List<SelectItem> items;
        Measure result = width;
        UIMenuSelectOne radio = (UIMenuSelectOne)command.getFacet("radio");
        if (radio == null) {
            items = SelectItemUtils.getItemList(facesContext, (UIComponent)command);
            radio = CreateComponentUtils.createUIMenuSelectOneFacet((FacesContext)facesContext, (UICommand)command);
            radio.setId(facesContext.getViewRoot().createUniqueId());
        } else {
            items = SelectItemUtils.getItemList(facesContext, (UIComponent)radio);
        }
        if (radio != null) {
            writer.startElement("span", (UIComponent)radio);
            Markup itemMarkup = radio instanceof SupportsMarkup ? ((SupportsMarkup)radio).getCurrentMarkup() : Markup.NULL;
            writer.writeClassAttribute(Classes.createWorkaround((String)"toolBar", (String)"selectOne", (Markup)itemMarkup));
            Object value = radio.getValue();
            String currentValue = "";
            boolean markFirst = !this.hasSelectedValue(items, value);
            String radioId = radio.getClientId(facesContext);
            for (SelectItem item : items) {
                boolean checked;
                String labelText = item.getLabel();
                if (labelText != null) {
                    command.getAttributes().put("label", labelText);
                } else {
                    LOG.warn("Menu item has label=null. UICommand.getClientId()=" + command.getClientId(facesContext));
                }
                String image = null;
                if (item instanceof org.apache.myfaces.tobago.model.SelectItem) {
                    image = ((org.apache.myfaces.tobago.model.SelectItem)item).getImage();
                }
                if (image == null) {
                    image = "image/1x1";
                }
                command.getAttributes().put("image", image);
                if (item.getDescription() != null) {
                    command.getAttributes().put("tip", item.getDescription());
                }
                String formattedValue = RenderUtils.getFormattedValue(facesContext, (UIComponent)radio, item.getValue());
                if (ObjectUtils.equals((Object)item.getValue(), (Object)value) || markFirst) {
                    checked = true;
                    markFirst = false;
                    currentValue = formattedValue;
                } else {
                    checked = false;
                }
                CommandMap map = new CommandMap(new Command());
                result = this.renderToolbarButton(facesContext, toolBar, command, writer, checked, result, map, formattedValue);
            }
            writer.startElement("input", null);
            writer.writeAttribute("type", "hidden", false);
            writer.writeNameAttribute(radioId);
            writer.writeAttribute("value", currentValue, true);
            writer.endElement("input");
            writer.endElement("span");
        }
        return result;
    }

    private Measure renderSelectBoolean(FacesContext facesContext, UIToolBar toolBar, AbstractUICommand command, TobagoResponseWriter writer, Measure width) throws IOException {
        Measure result = width;
        UIComponent checkbox = command.getFacet("checkbox");
        if (checkbox == null) {
            checkbox = CreateComponentUtils.createUISelectBooleanFacetWithId((FacesContext)facesContext, (UICommand)command);
        }
        boolean checked = ComponentUtils.getBooleanAttribute((UIComponent)checkbox, (String)"value");
        String clientId = checkbox.getClientId(facesContext);
        writer.startElement("span", checkbox);
        Markup itemMarkup = checkbox instanceof SupportsMarkup ? ((SupportsMarkup)checkbox).getCurrentMarkup() : Markup.NULL;
        writer.writeClassAttribute(Classes.createWorkaround((String)"toolBar", (String)"selectBoolean", (Markup)itemMarkup));
        CommandMap map = new CommandMap(new Command());
        result = this.renderToolbarButton(facesContext, toolBar, command, writer, checked, result, map, null);
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(clientId);
        writer.writeAttribute("value", Boolean.toString(checked), false);
        writer.endElement("input");
        writer.endElement("span");
        return result;
    }

    private Measure renderToolbarButton(FacesContext facesContext, UIToolBar toolBar, AbstractUICommand command, TobagoResponseWriter writer, boolean selected, Measure width, CommandMap map, String value) throws IOException {
        Markup itemMarkup;
        Style iconStyle;
        Style labelStyle;
        if (!command.isRendered()) {
            return width;
        }
        boolean disabled = ComponentUtils.getBooleanAttribute((UIComponent)command, (String)"disabled");
        LabelWithAccessKey label = command instanceof SupportsAccessKey ? new LabelWithAccessKey((SupportsAccessKey)command) : new LabelWithAccessKey(command.getLabel());
        AbstractUIMenu dropDownMenu = FacetUtils.getDropDownMenu((UIComponent)command);
        ResourceManager resources = this.getResourceManager();
        String labelPosition = this.getLabelPosition(command.getParent());
        String iconSize = this.getIconSize(command.getParent());
        String iconName = (String)command.getAttributes().get("image");
        boolean lackImage = iconName == null;
        String image = lackImage ? null : this.getImage(facesContext, iconName, iconSize, disabled, selected);
        boolean showIcon = !"off".equals(iconSize);
        boolean iconBig = "big".equals(iconSize);
        boolean showLabelBottom = "bottom".equals(labelPosition);
        boolean showLabelRight = "right".equals(labelPosition);
        boolean showLabel = showLabelBottom || showLabelRight;
        boolean showDropDownMenu = dropDownMenu != null && dropDownMenu.isRendered();
        boolean separateButtons = this.hasAnyCommand(command) && showDropDownMenu;
        Measure paddingTop = resources.getThemeMeasure(facesContext, (Configurable)toolBar, "custom.padding-top");
        Measure paddingMiddle = resources.getThemeMeasure(facesContext, (Configurable)toolBar, "custom.padding-middle");
        Measure paddingBottom = resources.getThemeMeasure(facesContext, (Configurable)toolBar, "custom.padding-bottom");
        Measure paddingLeft = resources.getThemeMeasure(facesContext, (Configurable)toolBar, "custom.padding-left");
        Measure paddingCenter = resources.getThemeMeasure(facesContext, (Configurable)toolBar, "custom.padding-center");
        Measure paddingRight = resources.getThemeMeasure(facesContext, (Configurable)toolBar, "custom.padding-right");
        Measure iconBigHeight = resources.getThemeMeasure(facesContext, (Configurable)toolBar, "custom.icon-big-height");
        Measure iconSmallHeight = resources.getThemeMeasure(facesContext, (Configurable)toolBar, "custom.icon-small-height");
        Measure iconBigWidth = resources.getThemeMeasure(facesContext, (Configurable)toolBar, "custom.icon-big-width");
        Measure iconSmallWidth = resources.getThemeMeasure(facesContext, (Configurable)toolBar, "custom.icon-small-width");
        if (showLabel) {
            labelStyle = new Style();
            labelStyle.setLeft(paddingLeft);
            labelStyle.setTop(paddingTop);
            labelStyle.setWidth(RenderUtils.calculateStringWidth(facesContext, (UIComponent)toolBar, label.getLabel()));
            labelStyle.setHeight(resources.getThemeMeasure(facesContext, (Configurable)toolBar, "custom.label-height"));
        } else {
            labelStyle = null;
        }
        Style buttonStyle = new Style();
        buttonStyle.setLeft(Measure.ZERO);
        buttonStyle.setTop(Measure.ZERO);
        buttonStyle.setWidth(paddingLeft.add(paddingRight));
        buttonStyle.setHeight(paddingBottom.add(paddingTop));
        if (showIcon) {
            iconStyle = new Style();
            iconStyle.setLeft(paddingLeft);
            iconStyle.setTop(paddingTop);
            iconStyle.setHeight(iconBig ? iconBigHeight : iconSmallHeight);
            if (lackImage && showLabelRight && StringUtils.isNotBlank((String)label.getLabel())) {
                iconStyle.setWidth(Measure.valueOf((int)1));
            } else {
                iconStyle.setWidth(iconBig ? iconBigWidth : iconSmallWidth);
            }
            if (showLabelBottom) {
                labelStyle.setTop(labelStyle.getTop().add(iconStyle.getHeight()).add(paddingMiddle));
                if (labelStyle.getWidth().lessThan(iconStyle.getWidth())) {
                    labelStyle.setLeft(labelStyle.getLeft().add(iconStyle.getWidth().subtract(labelStyle.getWidth()).divide(2)));
                    buttonStyle.setWidth(buttonStyle.getWidth().add(iconStyle.getWidth()));
                } else {
                    iconStyle.setLeft(iconStyle.getLeft().add(labelStyle.getWidth().subtract(iconStyle.getWidth()).divide(2)));
                    buttonStyle.setWidth(buttonStyle.getWidth().add(labelStyle.getWidth()));
                }
                buttonStyle.setHeight(buttonStyle.getHeight().add(iconStyle.getHeight()).add(paddingMiddle).add(labelStyle.getHeight()));
            } else if (showLabelRight) {
                labelStyle.setTop(labelStyle.getTop().add(iconStyle.getHeight().subtract(labelStyle.getHeight()).divide(2)));
                labelStyle.setLeft(labelStyle.getLeft().add(iconStyle.getWidth()).add(paddingCenter));
                buttonStyle.setWidth(buttonStyle.getWidth().add(iconStyle.getWidth()).add(paddingCenter).add(labelStyle.getWidth()));
                buttonStyle.setHeight(buttonStyle.getHeight().add(iconStyle.getHeight()));
            } else {
                buttonStyle.setWidth(buttonStyle.getWidth().add(iconStyle.getWidth()));
                buttonStyle.setHeight(buttonStyle.getHeight().add(iconStyle.getHeight()));
            }
        } else {
            iconStyle = null;
            if (showLabel) {
                buttonStyle.setWidth(buttonStyle.getWidth().add(labelStyle.getWidth()));
                if (StringUtils.isBlank((String)label.getLabel())) {
                    buttonStyle.setWidth(buttonStyle.getWidth().add(iconSmallWidth));
                }
                buttonStyle.setHeight(buttonStyle.getHeight().add(labelStyle.getHeight()));
            } else {
                buttonStyle.setWidth(buttonStyle.getWidth().add(iconSmallWidth));
                buttonStyle.setHeight(buttonStyle.getHeight().add(iconSmallWidth));
            }
        }
        Style openerStyle = new Style();
        openerStyle.setWidth(resources.getThemeMeasure(facesContext, (Configurable)toolBar, "custom.opener-width"));
        openerStyle.setHeight(resources.getThemeMeasure(facesContext, (Configurable)toolBar, "custom.opener-height"));
        Style menuStyle = new Style();
        menuStyle.setLeft(buttonStyle.getWidth());
        menuStyle.setTop(Measure.ZERO);
        menuStyle.setWidth(paddingLeft.add(openerStyle.getWidth()).add(paddingRight));
        menuStyle.setHeight(buttonStyle.getHeight());
        openerStyle.setLeft(menuStyle.getWidth().subtract(openerStyle.getWidth()).divide(2));
        openerStyle.setTop(menuStyle.getHeight().subtract(openerStyle.getHeight()).divide(2));
        Style itemStyle = new Style();
        if (this.isRightAligned(toolBar)) {
            itemStyle.setLeft(resources.getThemeMeasure(facesContext, (Configurable)toolBar, "css.border-right-width"));
        }
        itemStyle.setWidth(showDropDownMenu ? buttonStyle.getWidth().add(menuStyle.getWidth()) : buttonStyle.getWidth());
        itemStyle.setHeight(buttonStyle.getHeight());
        if (showDropDownMenu && lackImage && !showLabel) {
            itemStyle.setWidth(openerStyle.getWidth());
            buttonStyle.setWidth(openerStyle.getWidth());
        }
        if (showDropDownMenu && !separateButtons && (!lackImage || StringUtils.isNotBlank((String)label.getLabel()))) {
            openerStyle.setLeft(openerStyle.getLeft().add(buttonStyle.getWidth()));
            buttonStyle.setWidth(buttonStyle.getWidth().add(menuStyle.getWidth()));
        }
        writer.startElement("span", (UIComponent)command);
        Markup markup = itemMarkup = command instanceof SupportsMarkup ? ((SupportsMarkup)command).getCurrentMarkup() : Markup.NULL;
        if (selected) {
            itemMarkup = itemMarkup.add(Markup.SELECTED);
        }
        if (disabled) {
            itemMarkup = itemMarkup.add(Markup.DISABLED);
        }
        writer.writeClassAttribute(Classes.create((UIComponent)toolBar, (String)"item", (Markup)itemMarkup));
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)command);
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        writer.writeStyleAttribute(itemStyle);
        writer.startElement("span", (UIComponent)command);
        if (separateButtons || !showDropDownMenu) {
            writer.writeClassAttribute(Classes.create((UIComponent)toolBar, (String)"button", (Markup)(selected ? Markup.SELECTED : Markup.NULL)));
        } else {
            writer.writeClassAttribute(Classes.create((UIComponent)toolBar, (String)"menu"));
        }
        writer.writeStyleAttribute(buttonStyle);
        if (!toolBar.isTransient()) {
            writer.writeIdAttribute(command.getClientId(facesContext));
        }
        if (!disabled && map != null) {
            writer.writeAttribute("data-tobago-commands", JsonUtils.encode(map), true);
        }
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)command);
        if (value != null) {
            writer.writeAttribute("data-tobago-value", value, true);
        }
        if (showIcon && iconName != null) {
            writer.startElement("img", (UIComponent)command);
            writer.writeAttribute("src", image, false);
            int dot = ResourceManagerUtils.indexOfExtension((String)iconName);
            String imageHover = dot != -1 ? ResourceManagerUtils.getImageOrDisabledImageWithPath((FacesContext)facesContext, (String)(iconName.substring(0, dot) + "Hover" + iconName.substring(dot)), (boolean)disabled, (boolean)true) : ResourceManagerUtils.getImageOrDisabledImage((FacesContext)facesContext, (String)(iconName + "Hover"), (boolean)disabled, (boolean)true);
            if (imageHover != null) {
                writer.writeAttribute("data-tobago-src-default", image, false);
                writer.writeAttribute("data-tobago-src-hover", imageHover, false);
            }
            writer.writeAttribute("alt", label.getLabel(), true);
            writer.writeStyleAttribute(iconStyle);
            writer.endElement("img");
        }
        if (showLabel) {
            writer.startElement("span", (UIComponent)command);
            writer.writeClassAttribute(Classes.create((UIComponent)toolBar, (String)"label"));
            writer.writeStyleAttribute(labelStyle);
            if (label.getLabel() != null) {
                HtmlRendererUtils.writeLabelWithAccessKey(writer, label);
            }
            writer.endElement("span");
        }
        if (separateButtons) {
            writer.endElement("span");
            writer.startElement("span", (UIComponent)command);
            writer.writeClassAttribute(Classes.create((UIComponent)toolBar, (String)"menu"));
            writer.writeStyleAttribute(menuStyle);
            writer.writeAttribute("type", "button", false);
        }
        if (showDropDownMenu) {
            writer.startElement("img", (UIComponent)command);
            boolean dropDownDisabled = ComponentUtils.getBooleanAttribute((UIComponent)dropDownMenu, (String)"disabled") || disabled;
            String menuImage = ResourceManagerUtils.getImageOrDisabledImage((FacesContext)facesContext, (String)"image/toolbarButtonMenu", (boolean)dropDownDisabled);
            writer.writeAttribute("src", menuImage, false);
            writer.writeStyleAttribute(openerStyle);
            writer.endElement("img");
            ToolBarRendererBase.renderDropDownMenu(facesContext, writer, dropDownMenu);
        }
        writer.endElement("span");
        writer.endElement("span");
        return width.add(itemStyle.getWidth()).add(2);
    }

    private Measure renderSeparator(FacesContext facesContext, UIToolBar toolBar, UIToolBarSeparator separator, TobagoResponseWriter writer, Measure width) throws IOException {
        if (!separator.isRendered()) {
            return width;
        }
        writer.startElement("span", (UIComponent)separator);
        writer.writeClassAttribute(Classes.create((UIComponent)toolBar, (String)"item", (Markup)Markup.DISABLED));
        Style itemStyle = new Style();
        itemStyle.setHeight(this.getItemHeight(facesContext, (Configurable)toolBar));
        itemStyle.setWidth(Measure.valueOf((int)10));
        writer.writeStyleAttribute(itemStyle);
        writer.startElement("span", (UIComponent)separator);
        writer.writeClassAttribute(Classes.create((UIComponent)toolBar, (String)"separator"));
        writer.endElement("span");
        writer.endElement("span");
        return width.add(itemStyle.getWidth()).add(2);
    }

    protected Measure getItemHeight(FacesContext facesContext, Configurable toolBar) {
        String iconSize = this.getIconSize((UIComponent)toolBar);
        String labelPosition = this.getLabelPosition((UIComponent)toolBar);
        boolean showIcon = !"off".equals(iconSize);
        boolean iconBig = "big".equals(iconSize);
        boolean iconSmall = "small".equals(iconSize);
        boolean showLabelBottom = "bottom".equals(labelPosition);
        boolean showLabelRight = "right".equals(labelPosition);
        boolean showLabel = showLabelBottom || showLabelRight;
        ResourceManager resources = this.getResourceManager();
        Measure paddingTop = resources.getThemeMeasure(facesContext, toolBar, "custom.padding-top");
        Measure paddingMiddle = resources.getThemeMeasure(facesContext, toolBar, "custom.padding-middle");
        Measure paddingBottom = resources.getThemeMeasure(facesContext, toolBar, "custom.padding-bottom");
        Measure iconHeight = iconBig ? resources.getThemeMeasure(facesContext, toolBar, "custom.icon-big-height") : resources.getThemeMeasure(facesContext, toolBar, "custom.icon-small-height");
        Measure labelHeight = resources.getThemeMeasure(facesContext, toolBar, "custom.label-height");
        Measure result = paddingTop;
        if (showIcon) {
            result = result.add(iconHeight);
            if (showLabel && showLabelBottom) {
                result = result.add(paddingMiddle);
                result = result.add(labelHeight);
            }
        } else {
            result = showLabel ? result.add(labelHeight) : result.add(16);
        }
        result = result.add(paddingBottom);
        return result;
    }

    private boolean hasAnyCommand(AbstractUICommand command) {
        return !this.hasNoCommand(command);
    }

    private boolean hasNoCommand(AbstractUICommand command) {
        return command.getAction() == null && command.getActionListener() == null && command.getActionListeners().length == 0 && command.getLink() == null && command.getAttributes().get("onclick") == null;
    }

    private String getImage(FacesContext facesContext, String name, String iconSize, boolean disabled, boolean selected) {
        int dot = ResourceManagerUtils.indexOfExtension((String)name);
        int pos = dot == -1 ? name.length() : dot;
        String key = name.substring(0, pos);
        String ext = name.substring(pos);
        String size = "";
        if ("small".equals(iconSize)) {
            size = "16";
        } else if ("big".equals(iconSize)) {
            size = "32";
        }
        String image = null;
        if (disabled && selected && (image = dot != -1 ? ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)(key + "SelectedDisabled" + size + ext), (boolean)true) : ResourceManagerUtils.getImage((FacesContext)facesContext, (String)(key + "SelectedDisabled" + size), (boolean)true)) == null) {
            image = dot != -1 ? ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)(key + "SelectedDisabled" + ext), (boolean)true) : ResourceManagerUtils.getImage((FacesContext)facesContext, (String)(key + "SelectedDisabled"), (boolean)true);
        }
        if (image == null && disabled && (image = dot != -1 ? ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)(key + "Disabled" + size + ext), (boolean)true) : ResourceManagerUtils.getImage((FacesContext)facesContext, (String)(key + "Disabled" + size), (boolean)true)) == null) {
            image = dot != -1 ? ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)(key + "Disabled" + ext), (boolean)true) : ResourceManagerUtils.getImage((FacesContext)facesContext, (String)(key + "Disabled"), (boolean)true);
        }
        if (image == null && selected && (image = dot != -1 ? ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)(key + "Selected" + size + ext), (boolean)true) : ResourceManagerUtils.getImage((FacesContext)facesContext, (String)(key + "Selected" + size), (boolean)true)) == null) {
            image = dot != -1 ? ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)(key + "Selected" + ext), (boolean)true) : ResourceManagerUtils.getImage((FacesContext)facesContext, (String)(key + "Selected"), (boolean)true);
        }
        if (image == null && (image = dot != -1 ? ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)(key + size + ext), (boolean)true) : ResourceManagerUtils.getImage((FacesContext)facesContext, (String)(key + size), (boolean)true)) == null) {
            image = dot != -1 ? ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)(key + ext), (boolean)true) : ResourceManagerUtils.getImage((FacesContext)facesContext, (String)key, (boolean)true);
        }
        return image;
    }

    public static void renderDropDownMenu(FacesContext facesContext, TobagoResponseWriter writer, AbstractUIMenu dropDownMenu) throws IOException {
        writer.startElement("ol", (UIComponent)dropDownMenu);
        writer.writeIdAttribute(dropDownMenu.getClientId(facesContext));
        writer.writeClassAttribute("tobago-menuBar tobago-menu-dropDownMenu");
        RenderUtils.encode(facesContext, (UIComponent)dropDownMenu);
        writer.endElement("ol");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    private boolean hasSelectedValue(Iterable<SelectItem> items, Object value) {
        for (SelectItem item : items) {
            if (!ObjectUtils.equals((Object)item.getValue(), (Object)value)) continue;
            return true;
        }
        return false;
    }
}

