/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.facelets.extension;

import java.io.IOException;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.TagAttribute;

public abstract class TobagoMenuExtensionHandler
extends ComponentHandler {
    private Class subComponentLastType = Object.class;
    private Metadata subComponentMapper;
    private TagAttribute fieldIdAttribute = this.getAttribute("fieldId");

    public TobagoMenuExtensionHandler(ComponentConfig config) {
        super(config);
    }

    protected abstract String getSubComponentType();

    protected abstract String getSubRendererType();

    protected abstract String getFacetName();

    public void applyNextHandler(FaceletContext faceletContext, UIComponent menuCommand) throws IOException {
        if (ComponentHandler.isNew((UIComponent)menuCommand)) {
            UIComponent component = (UIComponent)menuCommand.getFacets().remove(this.getFacetName());
            this.nextHandler.apply(faceletContext, component);
            menuCommand.getFacets().put(this.getFacetName(), component);
        } else {
            this.nextHandler.apply(faceletContext, menuCommand.getFacet(this.getFacetName()));
        }
    }

    public void onComponentCreated(FaceletContext faceletContext, UIComponent menuCommand, UIComponent parent) {
        Application application = faceletContext.getFacesContext().getApplication();
        UIComponent component = application.createComponent(this.getSubComponentType());
        String uid = this.fieldIdAttribute != null ? this.fieldIdAttribute.getValue(faceletContext) : menuCommand.getId() + "_tx_" + this.getFacetName();
        component.setId(uid);
        component.setRendererType(this.getSubRendererType());
        this.setSubComponentAttributes(faceletContext, component);
        menuCommand.getFacets().put(this.getFacetName(), component);
    }

    private void setSubComponentAttributes(FaceletContext ctx, Object instance) {
        if (instance != null) {
            Class<?> type = instance.getClass();
            if (this.subComponentMapper == null || !this.subComponentLastType.equals(type)) {
                this.subComponentLastType = type;
                this.subComponentMapper = this.createSubComponentMetaRuleset(type).finish();
            }
            this.subComponentMapper.applyMetadata(ctx, instance);
        }
    }

    protected MetaRuleset createSubComponentMetaRuleset(Class aClass) {
        MetaRuleset metaRuleset = super.createMetaRuleset(aClass);
        TagAttribute[] attrs = this.tag.getAttributes().getAll();
        for (int i = 0; i < attrs.length; ++i) {
            TagAttribute attr = attrs[i];
            if (attr.getLocalName().equals("converter") || attr.getLocalName().equals("value")) continue;
            metaRuleset.ignore(attr.getLocalName());
        }
        return metaRuleset;
    }

    protected MetaRuleset createMetaRuleset(Class aClass) {
        MetaRuleset metaRuleset = super.createMetaRuleset(aClass);
        metaRuleset.ignore("converter");
        metaRuleset.ignore("value");
        return metaRuleset;
    }
}

