/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.plugin.descriptor;

import java.io.Serializable;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Requirement
implements Serializable {
    final String role;
    final String roleHint;
    final String fieldName;

    protected Requirement(Builder builder) {
        String string = builder.role != null ? builder.role : (this.role = builder.base != null ? builder.base.role : null);
        String string2 = builder.roleHint != null ? builder.roleHint : (this.roleHint = builder.base != null ? builder.base.roleHint : null);
        this.fieldName = builder.fieldName != null ? builder.fieldName : (builder.base != null ? builder.base.fieldName : null);
    }

    public String getRole() {
        return this.role;
    }

    public String getRoleHint() {
        return this.roleHint;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Nonnull
    public Builder with() {
        return Requirement.newBuilder(this);
    }

    @Nonnull
    public Requirement withRole(String role) {
        return Requirement.newBuilder(this, true).role(role).build();
    }

    @Nonnull
    public Requirement withRoleHint(String roleHint) {
        return Requirement.newBuilder(this, true).roleHint(roleHint).build();
    }

    @Nonnull
    public Requirement withFieldName(String fieldName) {
        return Requirement.newBuilder(this, true).fieldName(fieldName).build();
    }

    @Nonnull
    public static Requirement newInstance() {
        return Requirement.newInstance(true);
    }

    @Nonnull
    public static Requirement newInstance(boolean withDefaults) {
        return Requirement.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Requirement.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Requirement from) {
        return Requirement.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Requirement from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Requirement base;
        String role;
        String roleHint;
        String fieldName;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(Requirement base, boolean forceCopy) {
            if (forceCopy) {
                this.role = base.role;
                this.roleHint = base.roleHint;
                this.fieldName = base.fieldName;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder role(String role) {
            this.role = role;
            return this;
        }

        @Nonnull
        public Builder roleHint(String roleHint) {
            this.roleHint = roleHint;
            return this;
        }

        @Nonnull
        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        @Nonnull
        public Requirement build() {
            if (!(this.base == null || this.role != null && this.role != this.base.role || this.roleHint != null && this.roleHint != this.base.roleHint || this.fieldName != null && this.fieldName != this.base.fieldName)) {
                return this.base;
            }
            return new Requirement(this);
        }
    }
}

