/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import bsh.EvalError;
import bsh.Interpreter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.testng.IMethodSelector;
import org.testng.IMethodSelectorContext;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.internal.ClassHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.Utils;
import org.testng.xml.XmlClass;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlMethodSelector
implements IMethodSelector {
    private static Interpreter s_interpreter;
    private Map<String, String> m_includedGroups = new HashMap<String, String>();
    private Map<String, String> m_excludedGroups = new HashMap<String, String>();
    private List<XmlClass> m_classes = null;
    private String m_expression = null;
    private Map<String, String> m_includedMethods = new HashMap<String, String>();
    private Map<String, String> m_logged = new HashMap<String, String>();
    private boolean m_isInitialized = false;
    private List<ITestNGMethod> m_testMethods = null;
    private boolean m_verbose = true;

    @Override
    public boolean includeMethod(IMethodSelectorContext context, ITestNGMethod tm, boolean isTestMethod) {
        if (!this.m_isInitialized) {
            this.m_isInitialized = true;
            this.init(context);
        }
        boolean result = false;
        result = null != this.m_expression ? this.includeMethodFromExpression(tm, isTestMethod) : this.includeMethodFromIncludeExclude(tm, isTestMethod);
        return result;
    }

    private static Interpreter getInterpreter() {
        if (null == s_interpreter) {
            s_interpreter = new Interpreter();
        }
        return s_interpreter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean includeMethodFromExpression(ITestNGMethod tm, boolean isTestMethod) {
        boolean result = false;
        Interpreter interpreter = XmlMethodSelector.getInterpreter();
        try {
            HashMap<String, String> groups = new HashMap<String, String>();
            for (String group : tm.getGroups()) {
                groups.put(group, group);
            }
            this.setContext(interpreter, tm.getMethod(), groups, tm);
            Object evalResult = interpreter.eval(this.m_expression);
            result = (Boolean)evalResult;
        }
        catch (EvalError evalError) {
            Utils.log("bsh.Interpreter", 2, new StringBuffer().append("Cannot evaluate expression:").append(this.m_expression).append(":").append(evalError.getMessage()).toString());
        }
        finally {
            this.resetContext(interpreter);
        }
        return result;
    }

    private void resetContext(Interpreter interpreter) {
        try {
            interpreter.unset("method");
            interpreter.unset("groups");
            interpreter.unset("testngMethod");
        }
        catch (EvalError evalError) {
            Utils.log("bsh.Interpreter", 2, new StringBuffer().append("Cannot reset interpreter:").append(evalError.getMessage()).toString());
        }
    }

    private void setContext(Interpreter interpreter, Method method, Map<String, String> groups, ITestNGMethod tm) {
        try {
            interpreter.set("method", method);
            interpreter.set("groups", groups);
            interpreter.set("testngMethod", tm);
        }
        catch (EvalError evalError) {
            throw new TestNGException("Cannot set BSH interpreter", evalError);
        }
    }

    private boolean includeMethodFromIncludeExclude(ITestNGMethod tm, boolean isTestMethod) {
        boolean result = false;
        Method m = tm.getMethod();
        String[] groups = tm.getGroups();
        Map<String, String> includedGroups = this.m_includedGroups;
        Map<String, String> excludedGroups = this.m_excludedGroups;
        if (includedGroups.size() == 0 && excludedGroups.size() == 0 && !this.hasIncludedMethods() && !this.hasExcludedMethods()) {
            result = true;
        } else if (includedGroups.size() == 0 && excludedGroups.size() == 0 && !isTestMethod) {
            result = true;
        } else if (this.m_includedMethods.containsKey(MethodHelper.calculateMethodCanonicalName(tm))) {
            result = true;
        } else {
            boolean isIncludedInGroups = XmlMethodSelector.isIncluded(groups, this.m_includedGroups.values());
            boolean isExcludedInGroups = XmlMethodSelector.isExcluded(groups, this.m_excludedGroups.values());
            if (isIncludedInGroups && !isExcludedInGroups) {
                result = true;
            } else if (isExcludedInGroups) {
                result = false;
            }
            if (isTestMethod) {
                Method method = tm.getMethod();
                Class<?> methodClass = method.getDeclaringClass();
                String fullMethodName = new StringBuffer().append(methodClass.getName()).append(".").append(method.getName()).toString();
                String[] fullyQualifiedMethodName = new String[]{fullMethodName};
                for (XmlClass xmlClass : this.m_classes) {
                    Class cls = ClassHelper.forName(xmlClass.getName());
                    if (null == cls) {
                        Utils.log("XmlMethodSelector", 1, new StringBuffer().append("Cannot find class in classpath ").append(xmlClass.getName()).toString());
                        continue;
                    }
                    if (!this.assignable(methodClass, cls)) continue;
                    List<String> includedMethods = this.createQualifiedMethodNames(xmlClass, xmlClass.getIncludedMethods());
                    boolean isIncludedInMethods = XmlMethodSelector.isIncluded(fullyQualifiedMethodName, includedMethods);
                    List<String> excludedMethods = this.createQualifiedMethodNames(xmlClass, xmlClass.getExcludedMethods());
                    boolean isExcludedInMethods = XmlMethodSelector.isExcluded(fullyQualifiedMethodName, excludedMethods);
                    if (!result) continue;
                    result = isIncludedInMethods && !isExcludedInMethods;
                }
            }
        }
        Package pkg = m.getDeclaringClass().getPackage();
        String methodName = pkg != null ? new StringBuffer().append(pkg.getName()).append(".").append(m.getName()).toString() : m.getName();
        this.logInclusion(result ? "Including" : "Excluding", "method", new StringBuffer().append(methodName).append("()").toString());
        return result;
    }

    private boolean assignable(Class sourceClass, Class targetClass) {
        return sourceClass.isAssignableFrom(targetClass) || targetClass.isAssignableFrom(sourceClass);
    }

    private void logInclusion(String including, String type, String name) {
        if (!this.m_logged.containsKey(name)) {
            XmlMethodSelector.log(4, new StringBuffer().append(including).append(" ").append(type).append(" ").append(name).toString());
            this.m_logged.put(name, name);
        }
    }

    private boolean hasIncludedMethods() {
        for (XmlClass xmlClass : this.m_classes) {
            if (xmlClass.getIncludedMethods().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean hasExcludedMethods() {
        for (XmlClass xmlClass : this.m_classes) {
            if (xmlClass.getExcludedMethods().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private List<String> createQualifiedMethodNames(XmlClass xmlClass, List<String> methods) {
        ArrayList<String> vResult = new ArrayList<String>();
        for (Class cls = xmlClass.getSupportClass(); null != cls; cls = cls.getSuperclass()) {
            for (String methodName : methods) {
                Method[] allMethods = cls.getDeclaredMethods();
                Pattern pattern = Pattern.compile(methodName);
                for (Method m : allMethods) {
                    if (!pattern.matcher(m.getName()).matches()) continue;
                    vResult.add(new StringBuffer().append(cls.getName()).append(".").append(m.getName()).toString());
                }
            }
        }
        return vResult;
    }

    public void setXmlClasses(List<XmlClass> classes) {
        this.m_classes = classes;
    }

    public Map<String, String> getExcludedGroups() {
        return this.m_excludedGroups;
    }

    public Map<String, String> getIncludedGroups() {
        return this.m_includedGroups;
    }

    public void setExcludedGroups(Map<String, String> excludedGroups) {
        this.m_excludedGroups = excludedGroups;
    }

    public void setIncludedGroups(Map<String, String> includedGroups) {
        this.m_includedGroups = includedGroups;
    }

    private static boolean isIncluded(String[] groups, Collection<String> includedGroups) {
        if (includedGroups.size() == 0) {
            return true;
        }
        return XmlMethodSelector.isMemberOf(groups, includedGroups);
    }

    private static boolean isExcluded(String[] groups, Collection<String> excludedGroups) {
        return XmlMethodSelector.isMemberOf(groups, excludedGroups);
    }

    private static boolean isMemberOf(String[] groups, Collection<String> list) {
        for (String group : groups) {
            for (String o : list) {
                String regexpStr = o.toString();
                boolean match = Pattern.matches(regexpStr, group);
                if (!match) continue;
                return true;
            }
        }
        return false;
    }

    private static void log(int level, String s) {
        Utils.log("XmlMethodSelector", level, s);
    }

    private static void ppp(String s) {
        System.out.println(new StringBuffer().append("[XmlMethodSelector] ").append(s).toString());
    }

    public void setExpression(String expression) {
        this.m_expression = expression;
    }

    @Override
    public void setTestMethods(List<ITestNGMethod> testMethods) {
        this.m_testMethods = testMethods;
    }

    private void init(IMethodSelectorContext context) {
        String[] groups = this.m_includedGroups.keySet().toArray(new String[this.m_includedGroups.size()]);
        HashSet<String> groupClosure = new HashSet<String>();
        HashSet<ITestNGMethod> methodClosure = new HashSet<ITestNGMethod>();
        ArrayList<ITestNGMethod> includedMethods = new ArrayList<ITestNGMethod>();
        for (ITestNGMethod m : this.m_testMethods) {
            if (!this.includeMethod(context, m, true)) continue;
            includedMethods.add(m);
        }
        MethodHelper.findGroupTransitiveClosure(this, includedMethods, this.m_testMethods, groups, groupClosure, methodClosure);
        if (this.m_includedGroups.size() > 0) {
            this.m_includedGroups = new HashMap<String, String>();
            for (String g : groupClosure) {
                this.m_includedGroups.put(g, g);
                XmlMethodSelector.log(4, new StringBuffer().append("Including group ").append(this.m_includedGroups.containsKey(g) ? ": " : "(implicit): ").append(g).toString());
            }
            for (ITestNGMethod m : methodClosure) {
                String methodName = new StringBuffer().append(m.getMethod().getDeclaringClass().getName()).append(".").append(m.getMethodName()).toString();
                this.m_includedMethods.put(methodName, methodName);
                this.logInclusion("Including", "method ", methodName);
            }
        }
    }

    public void setVerbose(boolean b) {
        this.m_verbose = b;
    }
}

