/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.token;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.knox.gateway.services.security.token.JWTokenAttributes;

public class JWTokenAttributesBuilder {
    private String userName;
    private List<String> audiences;
    private String algorithm;
    private long expires;
    private String signingKeystoreName;
    private String signingKeystoreAlias;
    private char[] signingKeystorePassphrase;
    private boolean managed;
    private String jku;
    private String type;
    private Set<String> groups;
    private String kid;
    private String issuer = "KNOXSSO";

    public JWTokenAttributesBuilder setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public JWTokenAttributesBuilder setAudiences(String audience) {
        return this.setAudiences(Collections.singletonList(audience));
    }

    public JWTokenAttributesBuilder setAudiences(List<String> audiences) {
        this.audiences = audiences;
        return this;
    }

    public JWTokenAttributesBuilder setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public JWTokenAttributesBuilder setExpires(long expires) {
        this.expires = expires;
        return this;
    }

    public JWTokenAttributesBuilder setSigningKeystoreName(String signingKeystoreName) {
        this.signingKeystoreName = signingKeystoreName;
        return this;
    }

    public JWTokenAttributesBuilder setSigningKeystoreAlias(String signingKeystoreAlias) {
        this.signingKeystoreAlias = signingKeystoreAlias;
        return this;
    }

    public JWTokenAttributesBuilder setSigningKeystorePassphrase(char[] signingKeystorePassphrase) {
        this.signingKeystorePassphrase = signingKeystorePassphrase;
        return this;
    }

    public JWTokenAttributesBuilder setManaged(boolean managed) {
        this.managed = managed;
        return this;
    }

    public JWTokenAttributesBuilder setJku(String jku) {
        this.jku = jku;
        return this;
    }

    public JWTokenAttributesBuilder setType(String type) {
        this.type = type;
        return this;
    }

    public JWTokenAttributesBuilder setGroups(Set<String> groups) {
        this.groups = groups;
        return this;
    }

    public JWTokenAttributesBuilder setKid(String kid) {
        this.kid = kid;
        return this;
    }

    public JWTokenAttributesBuilder setIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public JWTokenAttributes build() {
        return new JWTokenAttributes(this.userName, this.audiences == null ? new ArrayList() : this.audiences, this.algorithm, this.expires, this.signingKeystoreName, this.signingKeystoreAlias, this.signingKeystorePassphrase, this.managed, this.jku, this.type, this.groups, this.kid, this.issuer);
    }
}

