/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.config;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.util.HashMap;
import java.util.Map;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.generator.RandomValueGenerator;
import org.pac4j.core.util.generator.ValueGenerator;
import org.pac4j.oauth.config.OAuthConfiguration;

public class OAuth20Configuration
extends OAuthConfiguration<OAuth20Service, OAuth2AccessToken> {
    public static final String OAUTH_CODE = "code";
    public static final String STATE_REQUEST_PARAMETER = "state";
    private Map<String, String> customParams = new HashMap<String, String>();
    private boolean withState;
    private ValueGenerator stateGenerator = new RandomValueGenerator();
    private DefaultApi20 api;

    @Override
    protected void internalInit() {
        CommonHelper.assertNotNull((String)"api", (Object)this.api);
        super.internalInit();
    }

    @Override
    public OAuth20Service buildService(WebContext context, IndirectClient client) {
        this.init();
        String finalCallbackUrl = client.computeFinalCallbackUrl(context);
        return this.api.createService(this.key, this.secret, finalCallbackUrl, this.scope, this.responseType, null, null, this.httpClientConfig, null);
    }

    public Map<String, String> getCustomParams() {
        return this.customParams;
    }

    public void setCustomParams(Map<String, String> customParams) {
        this.customParams = customParams;
    }

    public boolean isWithState() {
        return this.withState;
    }

    public void setWithState(boolean withState) {
        this.withState = withState;
    }

    public ValueGenerator getStateGenerator() {
        return this.stateGenerator;
    }

    public void setStateGenerator(ValueGenerator stateGenerator) {
        CommonHelper.assertNotNull((String)"stateGenerator", (Object)stateGenerator);
        this.stateGenerator = stateGenerator;
    }

    public DefaultApi20 getApi() {
        return this.api;
    }

    public void setApi(DefaultApi20 api) {
        this.api = api;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"key", this.key, "secret", "[protected]", "tokenAsHeader", this.tokenAsHeader, "responseType", this.responseType, "scope", this.scope, "api", this.api, "hasBeenCancelledFactory", this.hasBeenCancelledFactory, "profileDefinition", this.profileDefinition, "httpClientConfig", this.httpClientConfig});
    }
}

