/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.workflow;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.workflow.Outcome;
import org.apache.wiki.workflow.Step;

public abstract class AbstractStep
implements Step {
    private static final long serialVersionUID = 8635678679349653768L;
    private Date m_start = Step.TIME_NOT_SET;
    private Date m_end = Step.TIME_NOT_SET;
    private final String m_key;
    private boolean m_completed = false;
    private final Map<Outcome, Step> m_successors;
    private int workflowId;
    private Map<String, Serializable> workflowContext;
    private Outcome m_outcome;
    private final List<String> m_errors = new ArrayList<String>();
    private boolean m_started = false;

    protected AbstractStep(String messageKey) {
        this.m_outcome = Outcome.STEP_CONTINUE;
        this.m_key = messageKey;
        this.m_successors = new LinkedHashMap<Outcome, Step>();
    }

    public AbstractStep(int workflowId, Map<String, Serializable> workflowContext, String messageKey) {
        this(messageKey);
        this.setWorkflow(workflowId, workflowContext);
    }

    @Override
    public final void addSuccessor(Outcome outcome, Step step) {
        this.m_successors.put(outcome, step);
    }

    @Override
    public final Collection<Outcome> getAvailableOutcomes() {
        Set<Outcome> outcomes = this.m_successors.keySet();
        return Collections.unmodifiableCollection(outcomes);
    }

    @Override
    public final List<String> getErrors() {
        return Collections.unmodifiableList(this.m_errors);
    }

    @Override
    public abstract Outcome execute(Context var1) throws WikiException;

    @Override
    public abstract Principal getActor();

    @Override
    public final Date getEndTime() {
        return this.m_end;
    }

    @Override
    public final String getMessageKey() {
        return this.m_key;
    }

    @Override
    public final synchronized Outcome getOutcome() {
        return this.m_outcome;
    }

    @Override
    public final Date getStartTime() {
        return this.m_start;
    }

    @Override
    public final boolean isCompleted() {
        return this.m_completed;
    }

    @Override
    public final boolean isStarted() {
        return this.m_started;
    }

    @Override
    public final synchronized void setOutcome(Outcome outcome) {
        if (!(this.m_successors.containsKey(outcome) || Outcome.STEP_CONTINUE.equals(outcome) || Outcome.STEP_ABORT.equals(outcome))) {
            throw new IllegalArgumentException("Outcome " + outcome.getMessageKey() + " is not supported for this Step.");
        }
        if (outcome.isCompletion()) {
            if (this.m_completed) {
                throw new IllegalStateException("Step has already been marked complete; cannot set again.");
            }
            this.m_completed = true;
            this.m_end = new Date(System.currentTimeMillis());
        }
        this.m_outcome = outcome;
    }

    @Override
    public final synchronized void start() throws WikiException {
        if (this.m_started) {
            throw new IllegalStateException("Step already started.");
        }
        this.m_started = true;
        this.m_start = new Date(System.currentTimeMillis());
    }

    @Override
    public final Step getSuccessor(Outcome outcome) {
        return this.m_successors.get(outcome);
    }

    @Override
    public final synchronized void setWorkflow(int workflowId, Map<String, Serializable> workflowContext) {
        this.workflowId = workflowId;
        this.workflowContext = workflowContext;
    }

    public int getWorkflowId() {
        return this.workflowId;
    }

    public Map<String, Serializable> getWorkflowContext() {
        return this.workflowContext;
    }

    protected final synchronized void addError(String message) {
        this.m_errors.add(message);
    }
}

