/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tasks.pages;

import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.filters.FilterManager;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.search.SearchManager;
import org.apache.wiki.workflow.Outcome;
import org.apache.wiki.workflow.Task;

public class SaveWikiPageTask
extends Task {
    private static final long serialVersionUID = 3190559953484411420L;

    public SaveWikiPageTask() {
        super("task.saveWikiPage");
    }

    @Override
    public Outcome execute(Context context) throws WikiException {
        String proposedText = (String)((Object)this.getWorkflowContext().get("fact.proposedText"));
        Page page = context.getPage();
        ((PageManager)context.getEngine().getManager(PageManager.class)).putPageText(page, proposedText);
        ((PageManager)context.getEngine().getManager(PageManager.class)).getPage(page.getName());
        ((RenderingManager)context.getEngine().getManager(RenderingManager.class)).textToHTML(context, proposedText);
        ((FilterManager)context.getEngine().getManager(FilterManager.class)).doPostSaveFiltering(context, proposedText);
        page.setVersion(-1);
        ((SearchManager)context.getEngine().getManager(SearchManager.class)).reindexPage(page);
        return Outcome.STEP_COMPLETE;
    }
}

