/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.TxLock;
import org.apache.ignite.internal.processors.cache.transactions.TxLockList;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class TxLocksResponse
extends GridCacheMessage {
    private static final long serialVersionUID = 0L;
    private long futId;
    @GridToStringInclude
    @GridDirectTransient
    private Map<IgniteTxKey, TxLockList> nearTxKeyLocks = new HashMap<IgniteTxKey, TxLockList>();
    @GridToStringInclude
    @GridDirectTransient
    private Set<IgniteTxKey> txKeys;
    @GridToStringExclude
    private IgniteTxKey[] nearTxKeysArr;
    @GridToStringExclude
    private IgniteTxKey[] txKeysArr;
    @GridToStringExclude
    private TxLockList[] locksArr;

    @Override
    public int handlerId() {
        return 0;
    }

    @Override
    public boolean cacheGroupMessage() {
        return false;
    }

    public long futureId() {
        return this.futId;
    }

    public void futureId(long futId) {
        this.futId = futId;
    }

    public Map<IgniteTxKey, TxLockList> txLocks() {
        return this.nearTxKeyLocks;
    }

    public TxLockList txLocks(IgniteTxKey txKey) {
        return this.nearTxKeyLocks.get(txKey);
    }

    public void addTxLock(IgniteTxKey txKey, TxLock txLock) {
        TxLockList lockList = this.nearTxKeyLocks.get(txKey);
        if (lockList == null) {
            lockList = new TxLockList();
            this.nearTxKeyLocks.put(txKey, lockList);
        }
        lockList.add(txLock);
    }

    public Set<IgniteTxKey> keys() {
        return this.txKeys;
    }

    public void addKey(IgniteTxKey key) {
        if (this.txKeys == null) {
            this.txKeys = new HashSet<IgniteTxKey>();
        }
        this.txKeys.add(key);
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    @Override
    public String toString() {
        return S.toString(TxLocksResponse.class, this);
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.nearTxKeyLocks != null && !this.nearTxKeyLocks.isEmpty()) {
            int len = this.nearTxKeyLocks.size();
            this.nearTxKeysArr = new IgniteTxKey[len];
            this.locksArr = new TxLockList[len];
            int i = 0;
            for (Map.Entry<IgniteTxKey, TxLockList> entry : this.nearTxKeyLocks.entrySet()) {
                IgniteTxKey key = entry.getKey();
                key.prepareMarshal(ctx.cacheContext(key.cacheId()));
                this.nearTxKeysArr[i] = key;
                this.locksArr[i] = entry.getValue();
                ++i;
            }
        }
        if (this.txKeys != null && !this.txKeys.isEmpty()) {
            this.txKeysArr = new IgniteTxKey[this.txKeys.size()];
            int i = 0;
            for (IgniteTxKey key : this.txKeys) {
                key.prepareMarshal(ctx.cacheContext(key.cacheId()));
                this.txKeysArr[i++] = key;
            }
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        try {
            super.finishUnmarshal(ctx, ldr);
            if (this.nearTxKeysArr != null) {
                for (int i = 0; i < this.nearTxKeysArr.length; ++i) {
                    IgniteTxKey txKey = this.nearTxKeysArr[i];
                    txKey.key().finishUnmarshal(ctx.cacheObjectContext(txKey.cacheId()), ldr);
                    this.txLocks().put(txKey, this.locksArr[i]);
                }
                this.nearTxKeysArr = null;
                this.locksArr = null;
            }
            if (this.txKeysArr != null) {
                this.txKeys = U.newHashSet(this.txKeysArr.length);
                for (IgniteTxKey txKey : this.txKeysArr) {
                    txKey.key().finishUnmarshal(ctx.cacheObjectContext(txKey.cacheId()), ldr);
                    this.txKeys.add(txKey);
                }
                this.txKeysArr = null;
            }
        }
        catch (Exception e) {
            throw new IgniteCheckedException(e);
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeLong("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeObjectArray("locksArr", this.locksArr, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeObjectArray("nearTxKeysArr", this.nearTxKeysArr, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeObjectArray("txKeysArr", this.txKeysArr, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.futId = reader.readLong("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.locksArr = reader.readObjectArray("locksArr", MessageCollectionItemType.MSG, TxLockList.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.nearTxKeysArr = reader.readObjectArray("nearTxKeysArr", MessageCollectionItemType.MSG, IgniteTxKey.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.txKeysArr = reader.readObjectArray("txKeysArr", MessageCollectionItemType.MSG, IgniteTxKey.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxLocksResponse.class);
    }

    @Override
    public short directType() {
        return -23;
    }

    @Override
    public byte fieldsCount() {
        return 7;
    }

    @Override
    public void onAckReceived() {
    }
}

