/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader.latch;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class LatchAckMessage
implements Message {
    private static final long serialVersionUID = 0L;
    private String latchId;
    private AffinityTopologyVersion topVer;
    private boolean isFinal;

    public LatchAckMessage(String latchId, AffinityTopologyVersion topVer, boolean isFinal) {
        this.latchId = latchId;
        this.topVer = topVer;
        this.isFinal = isFinal;
    }

    public LatchAckMessage() {
    }

    public String latchId() {
        return this.latchId;
    }

    public AffinityTopologyVersion topVer() {
        return this.topVer;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeBoolean("isFinal", this.isFinal)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeString("latchId", this.latchId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeAffinityTopologyVersion("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.isFinal = reader.readBoolean("isFinal");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.latchId = reader.readString("latchId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.topVer = reader.readAffinityTopologyVersion("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(LatchAckMessage.class);
    }

    @Override
    public short directType() {
        return 135;
    }

    @Override
    public byte fieldsCount() {
        return 3;
    }

    @Override
    public void onAckReceived() {
    }
}

