/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.compute;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeLoadBalancer;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoadBalancerResource;
import org.jetbrains.annotations.NotNull;

public abstract class ComputeTaskSplitAdapter<T, R>
extends ComputeTaskAdapter<T, R> {
    private static final long serialVersionUID = 0L;
    @LoadBalancerResource
    private ComputeLoadBalancer balancer;

    protected abstract Collection<? extends ComputeJob> split(int var1, T var2) throws IgniteException;

    @Override
    @NotNull
    public final Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, T arg) {
        assert (subgrid != null);
        assert (!subgrid.isEmpty());
        Collection<ComputeJob> jobs = this.split(subgrid.size(), arg);
        if (F.isEmpty(jobs)) {
            throw new IgniteException("Split returned no jobs.");
        }
        HashMap<ComputeJob, ClusterNode> map = U.newHashMap(jobs.size());
        for (ComputeJob job : jobs) {
            ClusterNode old = map.put(job, this.balancer.getBalancedNode(job, null));
            if (old == null) continue;
            throw new IgniteException("Failed to map task (same job instance is being mapped more than once) [job=" + job + ", task=" + this + ']');
        }
        return map;
    }
}

