/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.property;

import java.lang.reflect.Method;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.query.property.QueryPropertyAccessor;

public class QueryMethodsAccessor
implements QueryPropertyAccessor {
    private final Method getter;
    private final Method setter;
    private final String propName;

    public QueryMethodsAccessor(Method getter, Method setter, String propName) {
        getter.setAccessible(true);
        setter.setAccessible(true);
        this.getter = getter;
        this.setter = setter;
        this.propName = propName;
    }

    @Override
    public Object getValue(Object obj) throws IgniteCheckedException {
        try {
            return this.getter.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to invoke getter method [type=" + this.getType() + ", property=" + this.propName + "]", e);
        }
    }

    @Override
    public void setValue(Object obj, Object newVal) throws IgniteCheckedException {
        try {
            this.setter.invoke(obj, newVal);
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to invoke setter method [type=" + this.getType() + ", property=" + this.propName + "]", e);
        }
    }

    @Override
    public String getPropertyName() {
        return this.propName;
    }

    @Override
    public Class<?> getType() {
        return this.getter.getReturnType();
    }
}

