/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.cache.query.index.IndexKeyQueryCondition;
import org.apache.ignite.internal.cache.query.index.IndexSingleRangeQuery;

class IndexMultipleRangeQuery {
    private final List<IndexSingleRangeQuery> queries = new ArrayList<IndexSingleRangeQuery>();
    private final int critSize;
    private final int idxRowSize;

    IndexMultipleRangeQuery(int idxRowSize, int critSize) {
        this.critSize = critSize;
        this.idxRowSize = idxRowSize;
    }

    public List<IndexSingleRangeQuery> queries() {
        return this.queries;
    }

    int critSize() {
        return this.critSize;
    }

    void addIndexKeyCondition(int i, IndexKeyQueryCondition cond) {
        if (i == 0) {
            this.addFirstIndexKeyCondition(cond);
        } else {
            for (IndexSingleRangeQuery qry : this.queries) {
                qry.addCondition(cond, i);
            }
        }
    }

    private void addFirstIndexKeyCondition(IndexKeyQueryCondition keyCond) {
        if (keyCond.inVals() != null) {
            for (IndexKeyQueryCondition cond : keyCond.splitInToRanges()) {
                IndexSingleRangeQuery q = new IndexSingleRangeQuery(this.idxRowSize, this.critSize);
                q.addCondition(cond, 0);
                this.queries.add(q);
            }
        } else {
            IndexSingleRangeQuery qry = new IndexSingleRangeQuery(this.idxRowSize, this.critSize);
            qry.addCondition(keyCond, 0);
            this.queries.add(qry);
        }
    }
}

