/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.format;

import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSetter;
import com.vladsch.flexmark.util.data.NullableDataKey;
import com.vladsch.flexmark.util.format.CharWidthProvider;
import com.vladsch.flexmark.util.format.TableManipulator;
import com.vladsch.flexmark.util.format.options.DiscretionaryText;
import com.vladsch.flexmark.util.format.options.TableCaptionHandling;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import org.jetbrains.annotations.NotNull;

public class TableFormatOptions
implements MutableDataSetter {
    public static final char INTELLIJ_DUMMY_IDENTIFIER_CHAR = '\u001f';
    public static final String INTELLIJ_DUMMY_IDENTIFIER = SequenceUtils.US_CHARS;
    public static final CharPredicate INTELLIJ_DUMMY_IDENTIFIER_SET = value -> value == 31;
    public static final DataKey<Boolean> FORMAT_TABLE_LEAD_TRAIL_PIPES = new DataKey("FORMAT_TABLE_LEAD_TRAIL_PIPES", (Object)true);
    public static final DataKey<Boolean> FORMAT_TABLE_SPACE_AROUND_PIPES = new DataKey("FORMAT_TABLE_SPACE_AROUND_PIPES", (Object)true);
    public static final DataKey<Boolean> FORMAT_TABLE_ADJUST_COLUMN_WIDTH = new DataKey("FORMAT_TABLE_ADJUST_COLUMN_WIDTH", (Object)true);
    public static final DataKey<Boolean> FORMAT_TABLE_APPLY_COLUMN_ALIGNMENT = new DataKey("FORMAT_TABLE_APPLY_COLUMN_ALIGNMENT", (Object)true);
    public static final DataKey<Boolean> FORMAT_TABLE_FILL_MISSING_COLUMNS = new DataKey("FORMAT_TABLE_FILL_MISSING_COLUMNS", (Object)false);
    public static final NullableDataKey<Integer> FORMAT_TABLE_FILL_MISSING_MIN_COLUMN = new NullableDataKey("FORMAT_TABLE_FILL_MISSING_MIN_COLUMN", (Object)null);
    public static final DataKey<DiscretionaryText> FORMAT_TABLE_LEFT_ALIGN_MARKER = new DataKey("FORMAT_TABLE_LEFT_ALIGN_MARKER", (Object)DiscretionaryText.AS_IS);
    public static final DataKey<Integer> FORMAT_TABLE_MIN_SEPARATOR_COLUMN_WIDTH = new DataKey("FORMAT_TABLE_MIN_SEPARATOR_COLUMN_WIDTH", (Object)3);
    public static final DataKey<Integer> FORMAT_TABLE_MIN_SEPARATOR_DASHES = new DataKey("FORMAT_TABLE_MIN_SEPARATOR_DASHES", (Object)1);
    public static final DataKey<Boolean> FORMAT_TABLE_TRIM_CELL_WHITESPACE = new DataKey("FORMAT_TABLE_TRIM_CELL_WHITESPACE", (Object)true);
    public static final DataKey<TableCaptionHandling> FORMAT_TABLE_CAPTION = new DataKey("FORMAT_TABLE_CAPTION", (Object)TableCaptionHandling.AS_IS);
    public static final DataKey<DiscretionaryText> FORMAT_TABLE_CAPTION_SPACES = new DataKey("FORMAT_TABLE_CAPTION_SPACES", (Object)DiscretionaryText.AS_IS);
    public static final DataKey<String> FORMAT_TABLE_INDENT_PREFIX = new DataKey("FORMAT_TABLE_INDENT_PREFIX", (Object)"");
    public static final DataKey<TableManipulator> FORMAT_TABLE_MANIPULATOR = new DataKey("FORMAT_TABLE_MANIPULATOR", (Object)TableManipulator.NULL);
    public static final DataKey<CharWidthProvider> FORMAT_CHAR_WIDTH_PROVIDER = new DataKey("FORMAT_CHAR_WIDTH_PROVIDER", (Object)CharWidthProvider.NULL);
    public static final DataKey<Boolean> FORMAT_TABLE_DUMP_TRACKING_OFFSETS = new DataKey("FORMAT_TABLE_DUMP_TRACKING_OFFSETS", (Object)false);
    public final boolean leadTrailPipes;
    public final boolean spaceAroundPipes;
    public final boolean adjustColumnWidth;
    public final boolean applyColumnAlignment;
    public final boolean fillMissingColumns;
    public final Integer formatTableFillMissingMinColumn;
    public final boolean trimCellWhitespace;
    public final boolean dumpIntellijOffsets;
    public final DiscretionaryText leftAlignMarker;
    public final TableCaptionHandling formatTableCaption;
    public final DiscretionaryText formatTableCaptionSpaces;
    public final int minSeparatorColumnWidth;
    public final int minSeparatorDashes;
    public final CharWidthProvider charWidthProvider;
    public final String formatTableIndentPrefix;
    public final TableManipulator tableManipulator;
    public final int spaceWidth;
    public final int spacePad;
    public final int pipeWidth;
    public final int colonWidth;
    public final int dashWidth;

    public TableFormatOptions() {
        this(null);
    }

    public TableFormatOptions(DataHolder options) {
        this.leadTrailPipes = (Boolean)FORMAT_TABLE_LEAD_TRAIL_PIPES.get(options);
        this.spaceAroundPipes = (Boolean)FORMAT_TABLE_SPACE_AROUND_PIPES.get(options);
        this.adjustColumnWidth = (Boolean)FORMAT_TABLE_ADJUST_COLUMN_WIDTH.get(options);
        this.applyColumnAlignment = (Boolean)FORMAT_TABLE_APPLY_COLUMN_ALIGNMENT.get(options);
        this.fillMissingColumns = (Boolean)FORMAT_TABLE_FILL_MISSING_COLUMNS.get(options);
        this.formatTableFillMissingMinColumn = (Integer)FORMAT_TABLE_FILL_MISSING_MIN_COLUMN.get(options);
        this.leftAlignMarker = (DiscretionaryText)((Object)FORMAT_TABLE_LEFT_ALIGN_MARKER.get(options));
        this.minSeparatorColumnWidth = (Integer)FORMAT_TABLE_MIN_SEPARATOR_COLUMN_WIDTH.get(options);
        this.minSeparatorDashes = (Integer)FORMAT_TABLE_MIN_SEPARATOR_DASHES.get(options);
        this.charWidthProvider = (CharWidthProvider)FORMAT_CHAR_WIDTH_PROVIDER.get(options);
        this.formatTableCaption = (TableCaptionHandling)((Object)FORMAT_TABLE_CAPTION.get(options));
        this.formatTableCaptionSpaces = (DiscretionaryText)((Object)FORMAT_TABLE_CAPTION_SPACES.get(options));
        this.formatTableIndentPrefix = (String)FORMAT_TABLE_INDENT_PREFIX.get(options);
        this.trimCellWhitespace = (Boolean)FORMAT_TABLE_TRIM_CELL_WHITESPACE.get(options);
        this.tableManipulator = (TableManipulator)FORMAT_TABLE_MANIPULATOR.get(options);
        this.dumpIntellijOffsets = (Boolean)FORMAT_TABLE_DUMP_TRACKING_OFFSETS.get(options);
        this.spaceWidth = this.charWidthProvider.getSpaceWidth();
        this.spacePad = this.spaceAroundPipes ? 2 * this.spaceWidth : 0;
        this.pipeWidth = this.charWidthProvider.getCharWidth('|');
        this.colonWidth = this.charWidthProvider.getCharWidth(':');
        this.dashWidth = this.charWidthProvider.getCharWidth('-');
    }

    @NotNull
    public MutableDataHolder setIn(@NotNull MutableDataHolder dataHolder) {
        dataHolder.set(FORMAT_TABLE_LEAD_TRAIL_PIPES, (Object)this.leadTrailPipes);
        dataHolder.set(FORMAT_TABLE_SPACE_AROUND_PIPES, (Object)this.spaceAroundPipes);
        dataHolder.set(FORMAT_TABLE_ADJUST_COLUMN_WIDTH, (Object)this.adjustColumnWidth);
        dataHolder.set(FORMAT_TABLE_APPLY_COLUMN_ALIGNMENT, (Object)this.applyColumnAlignment);
        dataHolder.set(FORMAT_TABLE_FILL_MISSING_COLUMNS, (Object)this.fillMissingColumns);
        dataHolder.set(FORMAT_TABLE_FILL_MISSING_MIN_COLUMN, (Object)this.formatTableFillMissingMinColumn);
        dataHolder.set(FORMAT_TABLE_LEFT_ALIGN_MARKER, (Object)this.leftAlignMarker);
        dataHolder.set(FORMAT_TABLE_MIN_SEPARATOR_COLUMN_WIDTH, (Object)this.minSeparatorColumnWidth);
        dataHolder.set(FORMAT_TABLE_MIN_SEPARATOR_DASHES, (Object)this.minSeparatorDashes);
        dataHolder.set(FORMAT_CHAR_WIDTH_PROVIDER, (Object)this.charWidthProvider);
        dataHolder.set(FORMAT_TABLE_CAPTION, (Object)this.formatTableCaption);
        dataHolder.set(FORMAT_TABLE_CAPTION_SPACES, (Object)this.formatTableCaptionSpaces);
        dataHolder.set(FORMAT_TABLE_INDENT_PREFIX, (Object)this.formatTableIndentPrefix);
        dataHolder.set(FORMAT_TABLE_TRIM_CELL_WHITESPACE, (Object)this.trimCellWhitespace);
        dataHolder.set(FORMAT_TABLE_MANIPULATOR, (Object)this.tableManipulator);
        dataHolder.set(FORMAT_TABLE_DUMP_TRACKING_OFFSETS, (Object)this.dumpIntellijOffsets);
        return dataHolder;
    }
}

