/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.storage;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.tx.TransactionException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class PartitionScanPublisher<T>
implements Flow.Publisher<T> {
    private static final AtomicLong CURSOR_ID_GENERATOR = new AtomicLong();
    private final AtomicBoolean subscribed = new AtomicBoolean(false);
    private final InflightBatchRequestTracker inflightBatchRequestTracker;

    public PartitionScanPublisher(InflightBatchRequestTracker inflightBatchRequestTracker) {
        this.inflightBatchRequestTracker = inflightBatchRequestTracker;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException("Subscriber is null");
        }
        if (!this.subscribed.compareAndSet(false, true)) {
            subscriber.onError(new IllegalStateException("Scan publisher does not support multiple subscriptions."));
        }
        subscriber.onSubscribe(new PartitionScanSubscription(subscriber));
    }

    protected abstract CompletableFuture<Collection<T>> retrieveBatch(long var1, int var3);

    protected abstract CompletableFuture<Void> onClose(boolean var1, long var2, @Nullable Throwable var4);

    @TestOnly
    public long scanId(Flow.Subscription subscription) {
        return ((PartitionScanSubscription)subscription).scanId;
    }

    public static interface InflightBatchRequestTracker {
        public void onRequestBegin();

        public void onRequestEnd();
    }

    private class PartitionScanSubscription
    implements Flow.Subscription {
        private static final int INTERNAL_BATCH_SIZE = 10000;
        private final Flow.Subscriber<? super T> subscriber;
        private final long scanId;
        private final Object lock = new Object();
        private boolean canceled;
        private long requestedItemsCnt;
        private CompletableFuture<Void> serializationFuture = CompletableFutures.nullCompletedFuture();

        private PartitionScanSubscription(Flow.Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
            this.scanId = CURSOR_ID_GENERATOR.getAndIncrement();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void request(long n) {
            Object object = this.lock;
            synchronized (object) {
                if (this.canceled) {
                    return;
                }
                if (n <= 0L) {
                    this.serializationFuture = this.serializationFuture.thenRun(() -> {
                        IllegalArgumentException e = new IllegalArgumentException(IgniteStringFormatter.format((String)"Invalid amount of items requested [requested={}, minValue=1].", (Object[])new Object[]{n}));
                        this.completeSubscription(e);
                    });
                    return;
                }
                boolean shouldRetrieveBatch = this.requestedItemsCnt == 0L;
                this.requestedItemsCnt += n;
                if (this.requestedItemsCnt < 0L) {
                    this.requestedItemsCnt = Long.MAX_VALUE;
                }
                if (shouldRetrieveBatch) {
                    this.serializationFuture = ((CompletableFuture)this.serializationFuture.thenCompose(v -> this.retrieveAndProcessBatch())).whenComplete((v, err) -> {
                        if (err != null) {
                            this.completeSubscription((Throwable)err);
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            Object object = this.lock;
            synchronized (object) {
                if (this.canceled) {
                    return;
                }
                this.canceled = true;
                this.serializationFuture = this.serializationFuture.thenCompose(v -> PartitionScanPublisher.this.onClose(true, this.scanId, null));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completeSubscription(@Nullable Throwable t) {
            Object object = this.lock;
            synchronized (object) {
                if (this.canceled) {
                    return;
                }
                this.canceled = true;
            }
            PartitionScanPublisher.this.onClose(false, this.scanId, t).whenComplete((v, e) -> {
                if (t == null) {
                    if (e == null) {
                        this.subscriber.onComplete();
                    } else {
                        this.subscriber.onError((Throwable)e);
                    }
                } else {
                    this.subscriber.onError(t);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CompletableFuture<Void> retrieveAndProcessBatch() {
            int batchSize;
            Object object = this.lock;
            synchronized (object) {
                if (this.canceled) {
                    return CompletableFutures.nullCompletedFuture();
                }
                batchSize = (int)Math.min(this.requestedItemsCnt, 10000L);
            }
            assert (batchSize > 0) : batchSize;
            try {
                PartitionScanPublisher.this.inflightBatchRequestTracker.onRequestBegin();
            }
            catch (TransactionException e) {
                this.completeSubscription(e);
                return CompletableFutures.nullCompletedFuture();
            }
            return ((CompletableFuture)PartitionScanPublisher.this.retrieveBatch(this.scanId, batchSize).whenComplete((batch, err) -> PartitionScanPublisher.this.inflightBatchRequestTracker.onRequestEnd())).thenAccept(batch -> this.processBatch((Collection)batch, batchSize));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processBatch(Collection<T> batch, int requestedCnt) {
            assert (batch != null) : "Batch is null";
            assert (batch.size() <= requestedCnt) : "Got more rows than requested [batchSize=" + batch.size() + ", requested=" + requestedCnt + "]";
            batch.forEach(this.subscriber::onNext);
            Object object = this.lock;
            synchronized (object) {
                if (this.canceled) {
                    return;
                }
                if (batch.size() < requestedCnt) {
                    this.completeSubscription(null);
                } else {
                    this.requestedItemsCnt -= (long)batch.size();
                    if (this.requestedItemsCnt > 0L) {
                        this.serializationFuture = ((CompletableFuture)this.serializationFuture.thenCompose(v -> this.retrieveAndProcessBatch())).whenComplete((v, err) -> {
                            if (err != null) {
                                this.completeSubscription((Throwable)err);
                            }
                        });
                    }
                }
            }
        }
    }
}

