/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.Map;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.rules.ImmutableExpandDisjunctionForJoinInputsRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.immutables.value.Value;

@Value.Enclosing
public class ExpandDisjunctionForJoinInputsRule
extends RelRule<Config>
implements TransformationRule {
    protected ExpandDisjunctionForJoinInputsRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        ((Config)this.config).matchHandler().accept(this, call);
    }

    private static void matchFilter(ExpandDisjunctionForJoinInputsRule rule, RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        Join join = (Join)call.rel(1);
        RelBuilder builder = call.builder();
        ExpandDisjunctionForJoinInputsHelper helper = new ExpandDisjunctionForJoinInputsHelper(join.getLeft().getRowType().getFieldCount(), join.getRight().getRowType().getFieldCount(), join.getJoinType().canPushLeftFromAbove(), join.getJoinType().canPushRightFromAbove(), builder, ((Config)rule.config).bloat());
        Map expandResult = helper.expand(filter.getCondition());
        RexNode newCondition = builder.and(filter.getCondition(), expandResult.getOrDefault("left", builder.literal(true)), expandResult.getOrDefault("right", builder.literal(true)));
        if (newCondition.equals(filter.getCondition())) {
            return;
        }
        Filter newFilter = filter.copy(filter.getTraitSet(), join, newCondition);
        call.transformTo(newFilter);
    }

    private static void matchJoin(ExpandDisjunctionForJoinInputsRule rule, RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        RelBuilder builder = call.builder();
        ExpandDisjunctionForJoinInputsHelper helper = new ExpandDisjunctionForJoinInputsHelper(join.getLeft().getRowType().getFieldCount(), join.getRight().getRowType().getFieldCount(), join.getJoinType().canPushLeftFromWithin(), join.getJoinType().canPushRightFromWithin(), builder, ((Config)rule.config).bloat());
        Map expandResult = helper.expand(join.getCondition());
        RexNode newCondition = call.builder().and(join.getCondition(), expandResult.getOrDefault("left", builder.literal(true)), expandResult.getOrDefault("right", builder.literal(true)));
        if (newCondition.equals(join.getCondition())) {
            return;
        }
        Join newJoin = join.copy(join.getTraitSet(), newCondition, join.getLeft(), join.getRight(), join.getJoinType(), join.isSemiJoinDone());
        call.transformTo(newJoin);
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RelRule.Config {
        public static final Config FILTER = ImmutableExpandDisjunctionForJoinInputsRule.Config.builder().withDescription("ExpandDisjunctionForJoinInputsRule(Filter)").withMatchHandler((x$0, x$1) -> ExpandDisjunctionForJoinInputsRule.access$200(x$0, x$1)).build().withOperandSupplier(b0 -> b0.operand(Filter.class).oneInput(b1 -> b1.operand(Join.class).anyInputs()));
        public static final Config JOIN = ImmutableExpandDisjunctionForJoinInputsRule.Config.builder().withDescription("ExpandDisjunctionForJoinInputsRule(Join)").withMatchHandler((x$0, x$1) -> ExpandDisjunctionForJoinInputsRule.access$100(x$0, x$1)).build().withOperandSupplier(b -> b.operand(Join.class).anyInputs());

        @Override
        default public ExpandDisjunctionForJoinInputsRule toRule() {
            return new ExpandDisjunctionForJoinInputsRule(this);
        }

        default public int bloat() {
            return 100;
        }

        public RelRule.MatchHandler<ExpandDisjunctionForJoinInputsRule> matchHandler();

        public Config withMatchHandler(RelRule.MatchHandler<ExpandDisjunctionForJoinInputsRule> var1);
    }

    private static class ExpandDisjunctionForJoinInputsHelper
    extends RexUtil.ExpandDisjunctionHelper<String> {
        private final ImmutableBitSet leftBitmap;
        private final ImmutableBitSet rightBitmap;
        private final boolean canPushLeft;
        private final boolean canPushRight;
        private final String leftKey = "left";
        private final String rightKey = "right";

        private ExpandDisjunctionForJoinInputsHelper(int leftFieldCount, int rightFieldCount, boolean canPushLeft, boolean canPushRight, RelBuilder relBuilder, int maxNodeCount) {
            super(relBuilder, maxNodeCount);
            this.leftBitmap = ImmutableBitSet.range(0, leftFieldCount);
            this.rightBitmap = ImmutableBitSet.range(leftFieldCount, leftFieldCount + rightFieldCount);
            this.canPushLeft = canPushLeft;
            this.canPushRight = canPushRight;
        }

        @Override
        protected boolean canReturnEarly(RexNode condition, Map<String, RexNode> additionalConditions) {
            boolean earlyReturn = false;
            ImmutableBitSet inputRefs = RelOptUtil.InputFinder.bits(condition);
            if (inputRefs.isEmpty()) {
                earlyReturn = true;
            }
            if (!inputRefs.isEmpty() && this.leftBitmap.contains(inputRefs)) {
                earlyReturn = true;
                if (this.canPushLeft) {
                    this.checkExpandCount(condition.nodeCount());
                    additionalConditions.put("left", condition);
                }
            }
            if (!inputRefs.isEmpty() && this.rightBitmap.contains(inputRefs)) {
                earlyReturn = true;
                if (this.canPushRight) {
                    this.checkExpandCount(condition.nodeCount());
                    additionalConditions.put("right", condition);
                }
            }
            return earlyReturn;
        }
    }
}

