/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.proj.Projection;

public class KrovakProjection
extends Projection {
    boolean czech = false;

    public KrovakProjection() {
        this.minLatitude = Math.toRadians(-60.0);
        this.maxLatitude = Math.toRadians(60.0);
        this.minLongitude = Math.toRadians(-90.0);
        this.maxLongitude = Math.toRadians(90.0);
        this.initialize();
    }

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        double s45 = 0.785398163397448;
        double s90 = 2.0 * s45;
        double fi0 = this.projectionLatitude;
        double a = 1.0;
        double e2 = 0.006674372230614;
        double e = Math.sqrt(e2);
        double alfa = Math.sqrt(1.0 + e2 * Math.pow(Math.cos(fi0), 4.0) / (1.0 - e2));
        double uq = 1.04216856380474;
        double u0 = Math.asin(Math.sin(fi0) / alfa);
        double g = Math.pow((1.0 + e * Math.sin(fi0)) / (1.0 - e * Math.sin(fi0)), alfa * e / 2.0);
        double k = Math.tan(u0 / 2.0 + s45) / Math.pow(Math.tan(fi0 / 2.0 + s45), alfa) * g;
        double k1 = this.scaleFactor;
        double n0 = a * Math.sqrt(1.0 - e2) / (1.0 - e2 * Math.pow(Math.sin(fi0), 2.0));
        double s0 = 1.37008346281555;
        double n = Math.sin(s0);
        double ro0 = k1 * n0 / Math.tan(s0);
        double ad = s90 - uq;
        double gfi = Math.pow((1.0 + e * Math.sin(lpphi)) / (1.0 - e * Math.sin(lpphi)), alfa * e / 2.0);
        double u = 2.0 * (Math.atan(k * Math.pow(Math.tan(lpphi / 2.0 + s45), alfa) / gfi) - s45);
        double deltav = -lplam * alfa;
        double s = Math.asin(Math.cos(ad) * Math.sin(u) + Math.sin(ad) * Math.cos(u) * Math.cos(deltav));
        double d = Math.asin(Math.cos(u) * Math.sin(deltav) / Math.cos(s));
        double eps = n * d;
        double ro = ro0 * Math.pow(Math.tan(s0 / 2.0 + s45), n) / Math.pow(Math.tan(s / 2.0 + s45), n);
        out.y = ro * Math.cos(eps) / a;
        out.x = ro * Math.sin(eps) / a;
        if (!this.czech) {
            out.y *= -1.0;
            out.x *= -1.0;
        }
        return out;
    }

    @Override
    protected ProjCoordinate projectInverse(double x, double y, ProjCoordinate dst) {
        double s45 = 0.785398163397448;
        double s90 = 2.0 * s45;
        double fi0 = this.projectionLatitude;
        double a = 1.0;
        double e2 = 0.006674372230614;
        double e = Math.sqrt(e2);
        double alfa = Math.sqrt(1.0 + e2 * Math.pow(Math.cos(fi0), 4.0) / (1.0 - e2));
        double uq = 1.04216856380474;
        double u0 = Math.asin(Math.sin(fi0) / alfa);
        double g = Math.pow((1.0 + e * Math.sin(fi0)) / (1.0 - e * Math.sin(fi0)), alfa * e / 2.0);
        double k = Math.tan(u0 / 2.0 + s45) / Math.pow(Math.tan(fi0 / 2.0 + s45), alfa) * g;
        double k1 = this.scaleFactor;
        double n0 = a * Math.sqrt(1.0 - e2) / (1.0 - e2 * Math.pow(Math.sin(fi0), 2.0));
        double s0 = 1.37008346281555;
        double n = Math.sin(s0);
        double ro0 = k1 * n0 / Math.tan(s0);
        double ad = s90 - uq;
        double xy0 = dst.x;
        dst.x = dst.y;
        dst.y = xy0;
        if (!this.czech) {
            dst.x *= -1.0;
            dst.y *= -1.0;
        }
        double ro = Math.sqrt(dst.x * dst.x + dst.y * dst.y);
        double eps = Math.atan2(dst.y, dst.x);
        double d = eps / Math.sin(s0);
        double s = 2.0 * (Math.atan(Math.pow(ro0 / ro, 1.0 / n) * Math.tan(s0 / 2.0 + s45)) - s45);
        double u = Math.asin(Math.cos(ad) * Math.sin(s) - Math.sin(ad) * Math.cos(s) * Math.cos(d));
        double deltav = Math.asin(Math.cos(s) * Math.sin(d) / Math.cos(u));
        dst.x = this.projectionLongitude - deltav / alfa;
        double fi1 = u;
        boolean ok = false;
        do {
            dst.y = 2.0 * (Math.atan(Math.pow(k, -1.0 / alfa) * Math.pow(Math.tan(u / 2.0 + s45), 1.0 / alfa) * Math.pow((1.0 + e * Math.sin(fi1)) / (1.0 - e * Math.sin(fi1)), e / 2.0)) - s45);
            if (Math.abs(fi1 - dst.y) < 1.0E-15) {
                ok = true;
            }
            fi1 = dst.y;
        } while (!ok);
        dst.x -= this.projectionLongitude;
        return dst;
    }

    @Override
    public String toString() {
        return "Krovak";
    }
}

