/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.tx.impl.TransactionInflights;
import org.apache.ignite.internal.tx.message.FinishedTransactionsBatchMessage;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;

public class FinishedReadOnlyTransactionTracker {
    private static final TxMessagesFactory FACTORY = new TxMessagesFactory();
    private final TopologyService topologyService;
    private final MessagingService messagingService;
    private final TransactionInflights transactionInflights;
    private final FailureProcessor failureProcessor;

    public FinishedReadOnlyTransactionTracker(TopologyService topologyService, MessagingService messagingService, TransactionInflights transactionInflights, FailureProcessor failureProcessor) {
        this.topologyService = topologyService;
        this.messagingService = messagingService;
        this.transactionInflights = transactionInflights;
        this.failureProcessor = failureProcessor;
    }

    public void broadcastClosedTransactions() {
        try {
            Collection<UUID> txToSend = this.transactionInflights.finishedReadOnlyTransactions();
            if (!txToSend.isEmpty()) {
                FinishedTransactionsBatchMessage message = FACTORY.finishedTransactionsBatchMessage().transactions(txToSend).build();
                CompletableFuture[] messages = (CompletableFuture[])this.topologyService.allMembers().stream().map(clusterNode -> this.sendCursorCleanupCommand((InternalClusterNode)clusterNode, message)).toArray(CompletableFuture[]::new);
                CompletableFuture.allOf(messages).thenRun(() -> this.transactionInflights.removeTxContexts(txToSend));
            }
        }
        catch (Throwable err) {
            this.failureProcessor.process(new FailureContext(err, "Error occurred during broadcasting closed transactions."));
            throw err;
        }
    }

    private CompletableFuture<Void> sendCursorCleanupCommand(InternalClusterNode node, FinishedTransactionsBatchMessage message) {
        return this.messagingService.send(node, (NetworkMessage)message);
    }
}

