/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.ClusterService;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.NetworkMessage;
import org.apache.ignite.network.NetworkMessageHandler;
import org.apache.ignite.network.TopologyEventHandler;
import org.apache.ignite.raft.jraft.NodeManager;
import org.apache.ignite.raft.jraft.RaftMessageGroup;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.rpc.RpcContext;
import org.apache.ignite.raft.jraft.rpc.RpcProcessor;
import org.apache.ignite.raft.jraft.rpc.RpcServer;
import org.apache.ignite.raft.jraft.rpc.impl.ActionRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.ConnectionClosedEventListener;
import org.apache.ignite.raft.jraft.rpc.impl.PingRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.AddLearnersRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.AddPeerRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.ChangePeersAsyncRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.ChangePeersRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.GetLeaderRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.GetPeersRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.RemoveLearnersRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.RemovePeerRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.ResetLearnersRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.ResetPeerRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.SnapshotRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.TransferLeaderRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.core.AppendEntriesRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.core.GetFileRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.core.InstallSnapshotRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.core.ReadIndexRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.core.RequestVoteRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.core.TimeoutNowRequestProcessor;
import org.jetbrains.annotations.Nullable;

public class IgniteRpcServer
implements RpcServer<Void> {
    private static final IgniteLogger LOG = Loggers.forClass(IgniteRpcServer.class);
    private final ClusterService service;
    private final NodeManager nodeManager;
    private final Executor rpcExecutor;
    private final List<ConnectionClosedEventListener> listeners = new CopyOnWriteArrayList<ConnectionClosedEventListener>();
    private final Map<String, RpcProcessor> processors = new ConcurrentHashMap<String, RpcProcessor>();

    public IgniteRpcServer(final ClusterService service, NodeManager nodeManager, RaftMessagesFactory raftMessagesFactory, Executor rpcExecutor) {
        this.service = service;
        this.nodeManager = nodeManager;
        this.rpcExecutor = rpcExecutor;
        AppendEntriesRequestProcessor appendEntriesRequestProcessor = new AppendEntriesRequestProcessor(rpcExecutor, raftMessagesFactory);
        this.registerConnectionClosedEventListener(appendEntriesRequestProcessor);
        this.registerProcessor(appendEntriesRequestProcessor);
        this.registerProcessor(new GetFileRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new InstallSnapshotRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new RequestVoteRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new PingRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new TimeoutNowRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new ReadIndexRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new AddPeerRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new RemovePeerRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new ResetPeerRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new ChangePeersRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new ChangePeersAsyncRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new GetLeaderRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new SnapshotRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new TransferLeaderRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new GetPeersRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new AddLearnersRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new RemoveLearnersRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new ResetLearnersRequestProcessor(rpcExecutor, raftMessagesFactory));
        this.registerProcessor(new ActionRequestProcessor(rpcExecutor, raftMessagesFactory));
        RpcMessageHandler messageHandler = new RpcMessageHandler();
        service.messagingService().addMessageHandler(RaftMessageGroup.class, (NetworkMessageHandler)messageHandler);
        service.topologyService().addEventHandler(new TopologyEventHandler(){

            public void onAppeared(ClusterNode member) {
            }

            public void onDisappeared(ClusterNode member) {
                for (ConnectionClosedEventListener listener : IgniteRpcServer.this.listeners) {
                    listener.onClosed(service.topologyService().localMember().name(), member.name());
                }
            }
        });
    }

    @Override
    public void registerConnectionClosedEventListener(ConnectionClosedEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void registerProcessor(RpcProcessor<?> processor) {
        this.processors.put(processor.interest(), processor);
    }

    @Override
    public int boundPort() {
        return 0;
    }

    @Override
    public boolean init(Void opts) {
        return true;
    }

    public ClusterService clusterService() {
        return this.service;
    }

    @Override
    public void shutdown() {
    }

    public class RpcMessageHandler
    implements NetworkMessageHandler {
        public void onReceived(NetworkMessage message, final NetworkAddress senderAddr, final @Nullable Long correlationId) {
            Class<?> cls = message.getClass();
            RpcProcessor prc = IgniteRpcServer.this.processors.get(cls.getName());
            if (prc == null) {
                Class<?> iface;
                Class<?>[] classArray = cls.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (prc = IgniteRpcServer.this.processors.get((iface = classArray[i]).getName())) == null; ++i) {
                }
            }
            if (prc == null) {
                return;
            }
            RpcProcessor.ExecutorSelector selector = prc.executorSelector();
            Executor executor = null;
            if (selector != null) {
                executor = selector.select(prc.getClass().getName(), message, IgniteRpcServer.this.nodeManager);
            }
            if (executor == null) {
                executor = prc.executor();
            }
            if (executor == null) {
                executor = IgniteRpcServer.this.rpcExecutor;
            }
            RpcProcessor finalPrc = prc;
            try {
                executor.execute(() -> {
                    RpcContext context = new RpcContext(){

                        @Override
                        public NodeManager getNodeManager() {
                            return IgniteRpcServer.this.nodeManager;
                        }

                        @Override
                        public void sendResponse(Object responseObj) {
                            IgniteRpcServer.this.service.messagingService().respond(senderAddr, (NetworkMessage)responseObj, correlationId.longValue());
                        }

                        @Override
                        public NetworkAddress getRemoteAddress() {
                            return senderAddr;
                        }

                        @Override
                        public NetworkAddress getLocalAddress() {
                            return IgniteRpcServer.this.service.topologyService().localMember().address();
                        }
                    };
                    finalPrc.handleRequest(context, message);
                });
            }
            catch (RejectedExecutionException e) {
                LOG.warn("A request execution was rejected [sender={} req={} reason={}]", new Object[]{senderAddr, S.toString((Object)message), e.getMessage()});
            }
        }
    }
}

