/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.calcite.adapter.enumerable.EnumerableBatchNestedLoopJoin;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.ImmutableEnumerableBatchNestedLoopJoinRule;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.immutables.value.Value;

@Value.Enclosing
public class EnumerableBatchNestedLoopJoinRule
extends RelRule<Config> {
    protected EnumerableBatchNestedLoopJoinRule(Config config) {
        super(config);
    }

    @Deprecated
    protected EnumerableBatchNestedLoopJoinRule(Class<? extends Join> clazz, RelBuilderFactory relBuilderFactory, int batchSize) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).withOperandSupplier(b -> b.operand(clazz).anyInputs()).as(Config.class).withBatchSize(batchSize));
    }

    @Deprecated
    public EnumerableBatchNestedLoopJoinRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Deprecated
    public EnumerableBatchNestedLoopJoinRule(RelBuilderFactory relBuilderFactory, int batchSize) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withBatchSize(batchSize));
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        JoinRelType joinType = join.getJoinType();
        return joinType == JoinRelType.INNER || joinType == JoinRelType.LEFT || joinType == JoinRelType.ANTI || joinType == JoinRelType.SEMI;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        final int leftFieldCount = join.getLeft().getRowType().getFieldCount();
        RelOptCluster cluster = join.getCluster();
        final RexBuilder rexBuilder = cluster.getRexBuilder();
        RelBuilder relBuilder = call.builder();
        HashSet<CorrelationId> correlationIds = new HashSet<CorrelationId>();
        final ArrayList<RexNode> corrVarList = new ArrayList<RexNode>();
        int batchSize = ((Config)this.config).batchSize();
        for (int i = 0; i < batchSize; ++i) {
            CorrelationId correlationId = cluster.createCorrel();
            correlationIds.add(correlationId);
            corrVarList.add(rexBuilder.makeCorrel(join.getLeft().getRowType(), correlationId));
        }
        final RexNode corrVar0 = (RexNode)corrVarList.get(0);
        final ImmutableBitSet.Builder requiredColumns = ImmutableBitSet.builder();
        RexNode condition = join.getCondition().accept(new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef input) {
                int field = input.getIndex();
                if (field >= leftFieldCount) {
                    return rexBuilder.makeInputRef(input.getType(), input.getIndex() - leftFieldCount);
                }
                requiredColumns.set(field);
                return rexBuilder.makeFieldAccess(corrVar0, field);
            }
        });
        ArrayList<RexNode> conditionList = new ArrayList<RexNode>();
        conditionList.add(condition);
        int i = 1;
        while (i < batchSize) {
            final int corrIndex = i++;
            RexNode condition2 = condition.accept(new RexShuttle(){

                @Override
                public RexNode visitCorrelVariable(RexCorrelVariable variable) {
                    return variable.equals(corrVar0) ? (RexNode)corrVarList.get(corrIndex) : variable;
                }
            });
            conditionList.add(condition2);
        }
        relBuilder.push(join.getRight()).filter(relBuilder.or(conditionList));
        RelNode right = relBuilder.build();
        call.transformTo(EnumerableBatchNestedLoopJoin.create(EnumerableBatchNestedLoopJoinRule.convert(join.getLeft(), join.getLeft().getTraitSet().replace(EnumerableConvention.INSTANCE)), EnumerableBatchNestedLoopJoinRule.convert(right, right.getTraitSet().replace(EnumerableConvention.INSTANCE)), join.getCondition(), requiredColumns.build(), correlationIds, join.getJoinType()));
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableEnumerableBatchNestedLoopJoinRule.Config.of().withOperandSupplier(b -> b.operand(LogicalJoin.class).anyInputs()).withDescription("EnumerableBatchNestedLoopJoinRule");

        @Override
        default public EnumerableBatchNestedLoopJoinRule toRule() {
            return new EnumerableBatchNestedLoopJoinRule(this);
        }

        @Value.Default
        default public int batchSize() {
            return 100;
        }

        public Config withBatchSize(int var1);
    }
}

