/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.minio;

import io.minio.BucketExistsArgs;
import io.minio.CopyObjectArgs;
import io.minio.CopySource;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.Result;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.messages.Bucket;
import io.minio.messages.DeleteObject;
import io.minio.messages.Item;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.vfs.minio.MinioFileSystem;
import org.apache.hop.vfs.minio.util.MinioPipedOutputStream;

public class MinioFileObject
extends AbstractFileObject<MinioFileSystem> {
    public static final String PREFIX = "minio:///";
    public static final String DELIMITER = "/";
    protected MinioFileSystem fileSystem;
    protected String bucketName;
    protected String key;
    protected boolean attached = false;
    protected StatObjectResponse statObjectResponse;
    protected MinioPipedOutputStream outputStream;
    protected GetObjectResponse responseInputStream;

    protected MinioFileObject(AbstractFileName name, MinioFileSystem fileSystem) {
        super(name, (AbstractFileSystem)fileSystem);
        this.fileSystem = fileSystem;
        this.bucketName = this.getMinioBucketName();
        this.key = this.getBucketRelativePath();
    }

    public String getMinioBucketName() {
        String bucketName = this.getName().getPath();
        bucketName = bucketName.indexOf(DELIMITER, 1) > 1 ? bucketName.substring(0, bucketName.indexOf(DELIMITER, 1)) : bucketName.replaceAll(DELIMITER, "");
        if (bucketName.startsWith(DELIMITER)) {
            bucketName = bucketName.substring(1);
        }
        return bucketName;
    }

    protected boolean isRootBucket() {
        return StringUtils.isEmpty((String)this.bucketName);
    }

    protected long doGetContentSize() {
        if (this.statObjectResponse != null) {
            return this.statObjectResponse.size();
        }
        return -1L;
    }

    protected InputStream doGetInputStream() throws Exception {
        LogChannel.GENERAL.logDebug("Accessing content {0}", new Object[]{this.getQualifiedName()});
        this.close();
        GetObjectArgs args = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().object(this.key)).bucket(this.bucketName)).build();
        this.responseInputStream = this.fileSystem.getClient().getObject(args);
        return this.responseInputStream;
    }

    protected FileType doGetType() throws Exception {
        return this.getType();
    }

    protected String[] doListChildren() throws Exception {
        ArrayList<Object> childrenList = new ArrayList<Object>();
        if (this.isRootBucket()) {
            List buckets = this.fileSystem.getClient().listBuckets();
            for (Bucket bucket : buckets) {
                childrenList.add(bucket.name() + DELIMITER);
            }
        } else {
            Object path = this.key;
            if (!((String)path).endsWith(DELIMITER)) {
                path = (String)path + DELIMITER;
            }
            ListObjectsArgs args = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(this.bucketName)).prefix((String)path).build();
            Iterable results = this.fileSystem.getClient().listObjects(args);
            for (Result result : results) {
                Item item = (Item)result.get();
                if (item == null) continue;
                Object objectName = item.objectName();
                if (item.isDir() && !((String)objectName).endsWith(DELIMITER)) {
                    objectName = (String)objectName + DELIMITER;
                }
                if (((String)objectName).length() < this.key.length() || ((String)(objectName = ((String)objectName).substring(this.key.length()))).isEmpty() || DELIMITER.equals(objectName)) continue;
                childrenList.add(objectName);
            }
        }
        return childrenList.toArray(new String[0]);
    }

    protected String getBucketRelativePath() {
        if (this.getName().getPath().indexOf(DELIMITER, 1) >= 0) {
            return this.getName().getPath().substring(this.getName().getPath().indexOf(DELIMITER, 1) + 1);
        }
        return "";
    }

    public void doAttach() throws FileSystemException {
        if (this.attached) {
            return;
        }
        this.attached = true;
        LogChannel.GENERAL.logDebug("Attach called on {0}", new Object[]{this.getQualifiedName()});
        this.injectType(FileType.IMAGINARY);
        if (StringUtils.isEmpty((String)this.key)) {
            this.injectType(FileType.FOLDER);
            return;
        }
        try {
            StatObjectArgs statArgs = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.bucketName)).object(this.key)).build();
            this.statObjectResponse = this.fileSystem.getClient().statObject(statArgs);
            if (this.key.endsWith(DELIMITER)) {
                this.injectType(FileType.FOLDER);
            } else {
                this.injectType(this.getName().getType());
            }
        }
        catch (Exception e) {
            if (this.key.endsWith(DELIMITER)) {
                this.statObjectResponse = null;
            } else {
                try {
                    StatObjectArgs statArgs = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.bucketName)).object(this.key + DELIMITER)).build();
                    this.statObjectResponse = this.fileSystem.getClient().statObject(statArgs);
                    this.injectType(FileType.FOLDER);
                }
                catch (Exception ex) {
                    this.statObjectResponse = null;
                }
            }
        }
        finally {
            this.close();
        }
    }

    public void closeMinio() {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (this.responseInputStream != null) {
                this.responseInputStream.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.injectType(FileType.IMAGINARY);
            this.outputStream = null;
            this.responseInputStream = null;
            this.statObjectResponse = null;
            this.attached = false;
        }
    }

    public void doDetach() throws Exception {
        LogChannel.GENERAL.logDebug("detaching {0}", new Object[]{this.getQualifiedName()});
        this.closeMinio();
    }

    protected void doDelete() throws FileSystemException {
        this.doDelete(this.key, this.bucketName);
    }

    protected void doDelete(String key, String bucketName) throws FileSystemException {
        try {
            MinioClient client = this.fileSystem.getClient();
            if (this.getType() == FileType.FOLDER) {
                ListObjectsArgs listArgs = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).build();
                Iterable items = client.listObjects(listArgs);
                Iterator iterator = items.iterator();
                ArrayList<DeleteObject> deleteObjects = new ArrayList<DeleteObject>();
                while (iterator.hasNext()) {
                    Result result = (Result)iterator.next();
                    deleteObjects.add(new DeleteObject(((Item)result.get()).objectName()));
                }
                RemoveObjectsArgs removeArgs = (RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(bucketName)).objects(deleteObjects).build();
                client.removeObjects(removeArgs);
            }
            RemoveObjectArgs removeObjectArgs = (RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(key)).build();
            this.fileSystem.getClient().removeObject(removeObjectArgs);
            this.doDetach();
        }
        catch (Exception e) {
            throw new FileSystemException("Error deleting object " + key + " in bucket " + bucketName, (Throwable)e);
        }
    }

    public void createFolder() throws FileSystemException {
        MinioClient client = this.fileSystem.getClient();
        try {
            if (this.key.isEmpty()) {
                if (StringUtils.isEmpty((String)this.bucketName)) {
                    return;
                }
                BucketExistsArgs existsArgs = (BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.bucketName)).build();
                boolean exists = client.bucketExists(existsArgs);
                if (!exists) {
                    MakeBucketArgs args = (MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.bucketName)).build();
                    client.makeBucket(args);
                }
                return;
            }
            if (!this.key.endsWith(DELIMITER)) {
                this.key = this.key + DELIMITER;
            }
            PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucketName)).object(this.key)).contentType("application/x-directory").stream((InputStream)new ByteArrayInputStream(new byte[0]), 0L, -1L).build();
            client.putObject(args);
        }
        catch (Exception e) {
            throw new FileSystemException("Error creating folder", (Throwable)e);
        }
        finally {
            this.closeMinio();
            this.doAttach();
        }
    }

    public void createFile() throws FileSystemException {
        try {
            OutputStream os = this.doGetOutputStream(false);
            os.close();
            this.closeMinio();
            this.doAttach();
        }
        catch (Exception e) {
            throw new FileSystemException("error creating file", (Throwable)e);
        }
    }

    public OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        if (this.outputStream != null) {
            return this.outputStream;
        }
        this.outputStream = new MinioPipedOutputStream(this.fileSystem, this.bucketName, this.key);
        return this.outputStream;
    }

    public long doGetLastModifiedTime() {
        if (this.statObjectResponse == null) {
            return 0L;
        }
        return this.statObjectResponse.lastModified().toInstant().toEpochMilli();
    }

    protected void doCreateFolder() throws Exception {
        if (!this.isRootBucket()) {
            try {
                PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucketName)).object(this.key)).contentType("binary/octet-stream").build();
                this.fileSystem.getClient().putObject(args);
            }
            catch (Exception e) {
                throw new FileSystemException("vfs.provider.local/create-folder.error", (Object)this, (Throwable)e);
            }
        } else {
            throw new FileSystemException("vfs.provider/create-folder-not-supported.error");
        }
    }

    protected void doRename(FileObject newFile) throws Exception {
        if (this.getType().equals((Object)FileType.FOLDER)) {
            throw new FileSystemException("vfs.provider/rename-not-supported.error");
        }
        MinioFileObject dest = (MinioFileObject)newFile;
        CopySource source = (CopySource)((CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket(this.bucketName)).object(this.key)).build();
        if (!this.exists()) {
            throw new FileSystemException("vfs.provider/rename.error", new Object[]{this, newFile});
        }
        CopyObjectArgs args = (CopyObjectArgs)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().bucket(this.bucketName)).object(dest.key)).bucket(dest.bucketName)).source(source).build();
        this.fileSystem.getClient().copyObject(args);
        this.delete();
        this.closeMinio();
    }

    protected String getQualifiedName() {
        return this.getQualifiedName(this);
    }

    protected String getQualifiedName(MinioFileObject fileObject) {
        return fileObject.bucketName + DELIMITER + fileObject.key;
    }
}

