/*
 * Decompiled with CFR 0.152.
 */
package io.minio.messages;

import io.minio.Utils;
import io.minio.messages.Upload;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="ListMultipartUploadsResult", strict=false)
@Namespace(reference="http://s3.amazonaws.com/doc/2006-03-01/")
public class ListMultipartUploadsResult {
    @Element(name="Bucket")
    private String bucketName;
    @Element(name="EncodingType", required=false)
    private String encodingType;
    @Element(name="KeyMarker", required=false)
    private String keyMarker;
    @Element(name="UploadIdMarker", required=false)
    private String uploadIdMarker;
    @Element(name="NextKeyMarker", required=false)
    private String nextKeyMarker;
    @Element(name="NextUploadIdMarker", required=false)
    private String nextUploadIdMarker;
    @Element(name="MaxUploads")
    private int maxUploads;
    @Element(name="IsTruncated", required=false)
    private boolean isTruncated;
    @ElementList(name="Upload", inline=true, required=false)
    List<Upload> uploads;

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String keyMarker() {
        return Utils.urlDecode(this.keyMarker, this.encodingType);
    }

    public String uploadIdMarker() {
        return this.uploadIdMarker;
    }

    public String nextKeyMarker() {
        return Utils.urlDecode(this.nextKeyMarker, this.encodingType);
    }

    public String nextUploadIdMarker() {
        return this.nextUploadIdMarker;
    }

    public int maxUploads() {
        return this.maxUploads;
    }

    public String encodingType() {
        return this.encodingType;
    }

    public List<Upload> uploads() {
        return Utils.unmodifiableList(this.uploads);
    }
}

