/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.xp;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.RowProducer;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.RowAdapter;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformMetaDataCombi;
import org.apache.hop.testing.DataSet;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.PipelineUnitTestFieldMapping;
import org.apache.hop.testing.PipelineUnitTestSetLocation;
import org.apache.hop.testing.xp.RowCollection;

@ExtensionPoint(extensionPointId="PipelineStartThreads", id="InjectDataSetIntoTransformExtensionPoint", description="Inject a bunch of rows into a transform during preview")
public class InjectDataSetIntoTransformExtensionPoint
implements IExtensionPoint<IPipelineEngine<PipelineMeta>> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, IPipelineEngine<PipelineMeta> pipeline) throws HopException {
        if (!(pipeline instanceof LocalPipelineEngine)) {
            throw new HopPluginException("Unit tests can only run using a local pipeline engine type");
        }
        PipelineMeta pipelineMeta = pipeline.getPipelineMeta();
        boolean dataSetEnabled = "Y".equalsIgnoreCase(pipeline.getVariable("__UnitTest_Run__"));
        if (log.isDetailed()) {
            log.logDetailed("Data Set enabled? " + dataSetEnabled);
        }
        if (!dataSetEnabled) {
            return;
        }
        String unitTestName = pipeline.getVariable("__UnitTest_Name__");
        if (log.isDetailed()) {
            log.logDetailed("Unit test name: " + unitTestName);
        }
        try {
            IHopMetadataProvider metadataProvider = pipelineMeta.getMetadataProvider();
            if (StringUtil.isEmpty((String)unitTestName)) {
                return;
            }
            PipelineUnitTest unitTest = (PipelineUnitTest)metadataProvider.getSerializer(PipelineUnitTest.class).load(unitTestName);
            if (unitTest == null) {
                if (log.isDetailed()) {
                    log.logDetailed("Unit test '" + unitTestName + "' could not be found");
                }
                return;
            }
            for (TransformMeta transformMeta : pipeline.getPipelineMeta().getTransforms()) {
                String goldenDataSetName;
                PipelineUnitTestSetLocation goldenLocation;
                String transformName = transformMeta.getName();
                PipelineUnitTestSetLocation inputLocation = unitTest.findInputLocation(transformName);
                if (inputLocation != null && StringUtils.isNotEmpty((String)inputLocation.getDataSetName())) {
                    String inputDataSetName = inputLocation.getDataSetName();
                    log.logDetailed("Data Set location found for transform '" + transformName + "' and data set  " + inputDataSetName);
                    this.injectDataSetIntoTransform((LocalPipelineEngine)pipeline, inputDataSetName, metadataProvider, transformMeta, inputLocation);
                }
                if ((goldenLocation = unitTest.findGoldenLocation(transformName)) == null || StringUtil.isEmpty((String)(goldenDataSetName = goldenLocation.getDataSetName()))) continue;
                log.logDetailed("Capturing rows for validation at pipeline end, transform='" + transformMeta.getName() + "', golden set '" + goldenDataSetName);
                final RowCollection rowCollection = new RowCollection();
                HashMap<String, RowCollection> collectionMap = (HashMap<String, RowCollection>)pipeline.getExtensionDataMap().get("RowCollectionMap");
                if (collectionMap == null) {
                    collectionMap = new HashMap<String, RowCollection>();
                    pipeline.getExtensionDataMap().put("RowCollectionMap", collectionMap);
                }
                collectionMap.put(transformMeta.getName(), rowCollection);
                IEngineComponent component = pipeline.findComponent(transformMeta.getName(), 0);
                component.addRowListener((IRowListener)new RowAdapter(){

                    public void rowReadEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                        if (rowCollection.getRowMeta() == null) {
                            rowCollection.setRowMeta(rowMeta);
                        }
                        rowCollection.getRows().add(row);
                    }
                });
            }
        }
        catch (Throwable e) {
            throw new HopException("Unable to inject data set rows", e);
        }
    }

    private void injectDataSetIntoTransform(LocalPipelineEngine pipeline, String dataSetName, IHopMetadataProvider metadataProvider, TransformMeta transformMeta, PipelineUnitTestSetLocation inputLocation) throws HopException {
        DataSet dataSet = (DataSet)metadataProvider.getSerializer(DataSet.class).load(dataSetName);
        if (dataSet == null) {
            throw new HopException("Unable to find data set '" + dataSetName + "'");
        }
        ILogChannel log = pipeline.getLogChannel();
        RowProducer rowProducer = pipeline.addRowProducer(transformMeta.getName(), 0);
        TransformMetaDataCombi combi = null;
        for (TransformMetaDataCombi transform : pipeline.getTransforms()) {
            if (!transform.transformName.equals(transformMeta.getName())) continue;
            combi = transform;
            break;
        }
        if (combi != null) {
            List<Object[]> dataSetRows = dataSet.getAllRows((IVariables)pipeline, log, inputLocation);
            IRowMeta dataSetRowMeta = dataSet.getMappedDataSetFieldsRowMeta(inputLocation);
            RowMeta injectRowMeta = new RowMeta();
            int[] fieldIndexes = new int[inputLocation.getFieldMappings().size()];
            for (int i = 0; i < inputLocation.getFieldMappings().size(); ++i) {
                PipelineUnitTestFieldMapping fieldMapping = inputLocation.getFieldMappings().get(i);
                fieldIndexes[i] = dataSetRowMeta.indexOfValue(fieldMapping.getDataSetFieldName());
                if (fieldIndexes[i] < 0) {
                    throw new HopException("Unable to find mapped field '" + fieldMapping.getDataSetFieldName() + "' in data set '" + dataSet.getName() + "'");
                }
                IValueMeta injectValueMeta = dataSetRowMeta.getValueMeta(fieldIndexes[i]).clone();
                injectValueMeta.setName(fieldMapping.getTransformFieldName());
                injectRowMeta.addValueMeta(injectValueMeta);
            }
            log.logDetailed("Injecting data set '" + dataSetName + "' into transform '" + transformMeta.getName() + "', fields: " + Arrays.toString(injectRowMeta.getFieldNames()));
            Runnable runnable = () -> InjectDataSetIntoTransformExtensionPoint.lambda$injectDataSetIntoTransform$0(dataSetRows, (IRowMeta)injectRowMeta, fieldIndexes, rowProducer, dataSetName, transformMeta);
            Thread thread = new Thread(runnable);
            thread.start();
        }
    }

    private static /* synthetic */ void lambda$injectDataSetIntoTransform$0(List dataSetRows, IRowMeta injectRowMeta, int[] fieldIndexes, RowProducer rowProducer, String dataSetName, TransformMeta transformMeta) {
        try {
            for (Object[] dataSetRow : dataSetRows) {
                Object[] row = RowDataUtil.allocateRowData((int)injectRowMeta.size());
                for (int i = 0; i < fieldIndexes.length; ++i) {
                    row[i] = dataSetRow[fieldIndexes[i]];
                }
                rowProducer.putRow(injectRowMeta, row);
            }
            rowProducer.finished();
        }
        catch (Exception e) {
            throw new RuntimeException("Problem injecting data set '" + dataSetName + "' row into transform '" + transformMeta.getName() + "'", e);
        }
    }
}

