/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.core.fs.Path;

@Deprecated
@PublicEvolving
public class TextOutputFormat<T>
extends FileOutputFormat<T> {
    private static final long serialVersionUID = 1L;
    private static final int NEWLINE = 10;
    private String charsetName;
    private transient Charset charset;

    public TextOutputFormat(Path outputPath) {
        this(outputPath, "UTF-8");
    }

    public TextOutputFormat(Path outputPath, String charset) {
        super(outputPath);
        this.charsetName = charset;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) throws IllegalCharsetNameException, UnsupportedCharsetException {
        if (charsetName == null) {
            throw new NullPointerException();
        }
        if (!Charset.isSupported(charsetName)) {
            throw new UnsupportedCharsetException("The charset " + charsetName + " is not supported.");
        }
        this.charsetName = charsetName;
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        super.open(taskNumber, numTasks);
        try {
            this.charset = Charset.forName(this.charsetName);
        }
        catch (IllegalCharsetNameException e) {
            throw new IOException("The charset " + this.charsetName + " is not valid.", e);
        }
        catch (UnsupportedCharsetException e) {
            throw new IOException("The charset " + this.charsetName + " is not supported.", e);
        }
    }

    public void writeRecord(T record) throws IOException {
        byte[] bytes = record.toString().getBytes(this.charset);
        this.stream.write(bytes);
        this.stream.write(10);
    }

    public String toString() {
        return "TextOutputFormat (" + this.getOutputFilePath() + ") - " + this.charsetName;
    }

    public static interface TextFormatter<IN>
    extends Serializable {
        public String format(IN var1);
    }
}

