/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.util;

import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftInterval;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Locale;

public class RedshiftIntervalYearToMonth
extends RedshiftInterval
implements Serializable,
Cloneable {
    public RedshiftIntervalYearToMonth() {
        this.setType("intervaly2m");
    }

    public RedshiftIntervalYearToMonth(String value) throws SQLException {
        this();
        this.setValue(value);
        if (this.getDays() != 0 || this.getHours() != 0 || this.getMinutes() != 0 || this.getWholeSeconds() != 0 || this.getMicroSeconds() != 0) {
            throw new RedshiftException("Invalid value for Interval Year To Month. Value cannot contain day-time parts.");
        }
    }

    public RedshiftIntervalYearToMonth(int year, int month) throws SQLException {
        this();
        this.setValue(year * 12 + month, 0L);
    }

    public RedshiftIntervalYearToMonth(int month) throws SQLException {
        this();
        this.setValue(month, 0L);
    }

    public void setValue(int month) {
        super.setValue(month, 0L);
    }

    @Override
    public void setValue(int month, long time) {
        assert (time == 0L);
        super.setValue(month, 0L);
    }

    @Override
    public void setDays(int days) {
        assert (days == 0);
        super.setDays(0);
    }

    @Override
    public void setHours(int hours) {
        assert (hours == 0);
        super.setHours(0);
    }

    @Override
    public void setMinutes(int minutes) {
        assert (minutes == 0);
        super.setMinutes(0);
    }

    @Override
    public void setSeconds(double seconds) {
        assert (seconds == 0.0);
        super.setSeconds(0.0);
    }

    @Override
    public String getValue() {
        return String.format(Locale.ROOT, "%d years %d mons", this.getYears(), this.getMonths());
    }

    public void add(RedshiftIntervalYearToMonth interval) {
        interval.setValue(this.totalMonths() + interval.totalMonths());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RedshiftIntervalYearToMonth)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RedshiftIntervalYearToMonth pgi = (RedshiftIntervalYearToMonth)obj;
        return pgi.getYears() == this.getYears() && pgi.getMonths() == this.getMonths();
    }
}

