/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.model.Datapoint;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsResult;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.clientlibrary.types.UserRecord;
import com.amazonaws.services.kinesis.model.DescribeStreamSummaryRequest;
import com.amazonaws.services.kinesis.model.ExpiredIteratorException;
import com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.amazonaws.services.kinesis.model.LimitExceededException;
import com.amazonaws.services.kinesis.model.ListShardsRequest;
import com.amazonaws.services.kinesis.model.ListShardsResult;
import com.amazonaws.services.kinesis.model.ProvisionedThroughputExceededException;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.ShardFilter;
import com.amazonaws.services.kinesis.model.ShardFilterType;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import com.amazonaws.services.kinesis.model.StreamDescriptionSummary;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.apache.beam.sdk.io.kinesis.AWSClientsProvider;
import org.apache.beam.sdk.io.kinesis.GetKinesisRecordsResult;
import org.apache.beam.sdk.io.kinesis.KinesisClientThrottledException;
import org.apache.beam.sdk.io.kinesis.StartingPoint;
import org.apache.beam.sdk.io.kinesis.TransientKinesisException;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.Minutes;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

class SimplifiedKinesisClient {
    private static final @UnknownKeyFor @NonNull @Initialized String KINESIS_NAMESPACE = "AWS/Kinesis";
    private static final @UnknownKeyFor @NonNull @Initialized String INCOMING_RECORDS_METRIC = "IncomingBytes";
    private static final @UnknownKeyFor @NonNull @Initialized int PERIOD_GRANULARITY_IN_SECONDS = 60;
    private static final @UnknownKeyFor @NonNull @Initialized String SUM_STATISTIC = "Sum";
    private static final @UnknownKeyFor @NonNull @Initialized String STREAM_NAME_DIMENSION = "StreamName";
    private static final @UnknownKeyFor @NonNull @Initialized int LIST_SHARDS_MAX_RESULTS = 1000;
    private static final @UnknownKeyFor @NonNull @Initialized Duration SPACING_FOR_TIMESTAMP_LIST_SHARDS_REQUEST_TO_NOT_EXCEED_TRIM_HORIZON = Duration.standardMinutes((long)5L);
    private static final @UnknownKeyFor @NonNull @Initialized int DESCRIBE_STREAM_SUMMARY_MAX_ATTEMPTS = 10;
    private static final @UnknownKeyFor @NonNull @Initialized Duration DESCRIBE_STREAM_SUMMARY_INITIAL_BACKOFF = Duration.standardSeconds((long)1L);
    private final @UnknownKeyFor @NonNull @Initialized AmazonKinesis kinesis;
    private final @UnknownKeyFor @NonNull @Initialized AmazonCloudWatch cloudWatch;
    private final @UnknownKeyFor @NonNull @Initialized Integer limit;
    private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Instant> currentInstantSupplier;

    public SimplifiedKinesisClient(@UnknownKeyFor @NonNull @Initialized AmazonKinesis kinesis, @UnknownKeyFor @NonNull @Initialized AmazonCloudWatch cloudWatch, @UnknownKeyFor @NonNull @Initialized Integer limit) {
        this(kinesis, cloudWatch, limit, Instant::now);
    }

    SimplifiedKinesisClient(@UnknownKeyFor @NonNull @Initialized AmazonKinesis kinesis, @UnknownKeyFor @NonNull @Initialized AmazonCloudWatch cloudWatch, @UnknownKeyFor @NonNull @Initialized Integer limit, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Instant> currentInstantSupplier) {
        this.kinesis = (AmazonKinesis)Preconditions.checkNotNull((Object)kinesis, (Object)"kinesis");
        this.cloudWatch = (AmazonCloudWatch)Preconditions.checkNotNull((Object)cloudWatch, (Object)"cloudWatch");
        this.limit = limit;
        this.currentInstantSupplier = currentInstantSupplier;
    }

    public static @UnknownKeyFor @NonNull @Initialized SimplifiedKinesisClient from(@UnknownKeyFor @NonNull @Initialized AWSClientsProvider provider, @UnknownKeyFor @NonNull @Initialized Integer limit) {
        return new SimplifiedKinesisClient(provider.getKinesisClient(), provider.getCloudWatchClient(), limit);
    }

    public @UnknownKeyFor @NonNull @Initialized String getShardIterator(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized String shardId, @UnknownKeyFor @NonNull @Initialized ShardIteratorType shardIteratorType, @UnknownKeyFor @NonNull @Initialized String startingSequenceNumber, @UnknownKeyFor @NonNull @Initialized Instant timestamp) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        Date date = timestamp != null ? timestamp.toDate() : null;
        return this.wrapExceptions(() -> this.kinesis.getShardIterator(new GetShardIteratorRequest().withStreamName(streamName).withShardId(shardId).withShardIteratorType(shardIteratorType).withStartingSequenceNumber(startingSequenceNumber).withTimestamp(date)).getShardIterator());
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Shard> listShardsAtPoint(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized StartingPoint startingPoint) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        ShardFilter shardFilter = this.wrapExceptions(() -> this.buildShardFilterForStartingPoint(streamName, startingPoint));
        return this.listShards(streamName, shardFilter);
    }

    private @UnknownKeyFor @NonNull @Initialized ShardFilter buildShardFilterForStartingPoint(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized StartingPoint startingPoint) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        InitialPositionInStream position = startingPoint.getPosition();
        switch (position) {
            case LATEST: {
                return new ShardFilter().withType(ShardFilterType.AT_LATEST);
            }
            case TRIM_HORIZON: {
                return new ShardFilter().withType(ShardFilterType.AT_TRIM_HORIZON);
            }
            case AT_TIMESTAMP: {
                return this.buildShardFilterForTimestamp(streamName, startingPoint.getTimestamp());
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized '%s' position to create shard filter with", position));
    }

    private @UnknownKeyFor @NonNull @Initialized ShardFilter buildShardFilterForTimestamp(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized Instant startingPointTimestamp) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        StreamDescriptionSummary streamDescription = this.describeStreamSummary(streamName);
        Instant streamCreationTimestamp = new Instant((Object)streamDescription.getStreamCreationTimestamp());
        if (streamCreationTimestamp.isAfter((ReadableInstant)startingPointTimestamp)) {
            return new ShardFilter().withType(ShardFilterType.AT_TRIM_HORIZON);
        }
        Duration retentionPeriod = Duration.standardHours((long)streamDescription.getRetentionPeriodHours().intValue());
        Instant streamTrimHorizonTimestamp = this.currentInstantSupplier.get().minus((ReadableDuration)retentionPeriod).plus((ReadableDuration)SPACING_FOR_TIMESTAMP_LIST_SHARDS_REQUEST_TO_NOT_EXCEED_TRIM_HORIZON);
        if (startingPointTimestamp.isAfter((ReadableInstant)streamTrimHorizonTimestamp)) {
            return new ShardFilter().withType(ShardFilterType.AT_TIMESTAMP).withTimestamp(startingPointTimestamp.toDate());
        }
        return new ShardFilter().withType(ShardFilterType.AT_TRIM_HORIZON);
    }

    private @UnknownKeyFor @NonNull @Initialized StreamDescriptionSummary describeStreamSummary(@UnknownKeyFor @NonNull @Initialized String streamName) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        FluentBackoff retryBackoff = FluentBackoff.DEFAULT.withMaxRetries(10).withInitialBackoff(DESCRIBE_STREAM_SUMMARY_INITIAL_BACKOFF);
        BackOff backoff = retryBackoff.backoff();
        Sleeper sleeper = Sleeper.DEFAULT;
        DescribeStreamSummaryRequest request = new DescribeStreamSummaryRequest();
        request.setStreamName(streamName);
        while (true) {
            try {
                return this.kinesis.describeStreamSummary(request).getStreamDescriptionSummary();
            }
            catch (LimitExceededException exc) {
                if (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff)) continue;
                throw exc;
            }
            break;
        }
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Shard> listShardsFollowingClosedShard(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized String exclusiveStartShardId) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        ShardFilter shardFilter = new ShardFilter().withType(ShardFilterType.AFTER_SHARD_ID).withShardId(exclusiveStartShardId);
        return this.listShards(streamName, shardFilter);
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Shard> listShards(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized ShardFilter shardFilter) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        return (List)this.wrapExceptions(() -> {
            ListShardsResult response;
            ImmutableList.Builder shardsBuilder = ImmutableList.builder();
            String currentNextToken = null;
            do {
                ListShardsRequest request = new ListShardsRequest();
                request.setMaxResults(Integer.valueOf(1000));
                if (currentNextToken != null) {
                    request.setNextToken(currentNextToken);
                } else {
                    request.setStreamName(streamName);
                }
                request.setShardFilter(shardFilter);
                response = this.kinesis.listShards(request);
                List shards = response.getShards();
                shardsBuilder.addAll((Iterable)shards);
            } while ((currentNextToken = response.getNextToken()) != null);
            return shardsBuilder.build();
        });
    }

    public @UnknownKeyFor @NonNull @Initialized GetKinesisRecordsResult getRecords(@UnknownKeyFor @NonNull @Initialized String shardIterator, @UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized String shardId) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        return this.getRecords(shardIterator, streamName, shardId, this.limit);
    }

    public @UnknownKeyFor @NonNull @Initialized GetKinesisRecordsResult getRecords(@UnknownKeyFor @NonNull @Initialized String shardIterator, @UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized String shardId, @UnknownKeyFor @NonNull @Initialized Integer limit) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        return this.wrapExceptions(() -> {
            GetRecordsResult response = this.kinesis.getRecords(new GetRecordsRequest().withShardIterator(shardIterator).withLimit(limit));
            return new GetKinesisRecordsResult(UserRecord.deaggregate((List)response.getRecords()), response.getNextShardIterator(), response.getMillisBehindLatest(), streamName, shardId);
        });
    }

    public @UnknownKeyFor @NonNull @Initialized long getBacklogBytes(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized Instant countSince) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        return this.getBacklogBytes(streamName, countSince, new Instant());
    }

    public @UnknownKeyFor @NonNull @Initialized long getBacklogBytes(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized Instant countSince, @UnknownKeyFor @NonNull @Initialized Instant countTo) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        return this.wrapExceptions(() -> {
            Minutes period = Minutes.minutesBetween((ReadableInstant)countSince, (ReadableInstant)countTo);
            if (period.isLessThan(Minutes.ONE)) {
                return 0L;
            }
            GetMetricStatisticsRequest request = this.createMetricStatisticsRequest(streamName, countSince, countTo, period);
            long totalSizeInBytes = 0L;
            GetMetricStatisticsResult result = this.cloudWatch.getMetricStatistics(request);
            for (Datapoint point : result.getDatapoints()) {
                totalSizeInBytes += point.getSum().longValue();
            }
            return totalSizeInBytes;
        });
    }

    @UnknownKeyFor @NonNull @Initialized GetMetricStatisticsRequest createMetricStatisticsRequest(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized Instant countSince, @UnknownKeyFor @NonNull @Initialized Instant countTo, @UnknownKeyFor @NonNull @Initialized Minutes period) {
        return new GetMetricStatisticsRequest().withNamespace(KINESIS_NAMESPACE).withMetricName(INCOMING_RECORDS_METRIC).withPeriod(Integer.valueOf(period.getMinutes() * 60)).withStartTime(countSince.toDate()).withEndTime(countTo.toDate()).withStatistics(Collections.singletonList(SUM_STATISTIC)).withDimensions(Collections.singletonList(new Dimension().withName(STREAM_NAME_DIMENSION).withValue(streamName)));
    }

    private <T> T wrapExceptions(@UnknownKeyFor @NonNull @Initialized Callable<T> callable) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        try {
            return callable.call();
        }
        catch (ExpiredIteratorException e) {
            throw e;
        }
        catch (LimitExceededException | ProvisionedThroughputExceededException e) {
            throw new KinesisClientThrottledException("Too many requests to Kinesis. Wait some time and retry.", (AmazonClientException)e);
        }
        catch (AmazonServiceException e) {
            if (e.getErrorType() == AmazonServiceException.ErrorType.Service) {
                throw new TransientKinesisException("Kinesis backend failed. Wait some time and retry.", (AmazonClientException)((Object)e));
            }
            throw new RuntimeException("Kinesis client side failure", e);
        }
        catch (AmazonClientException e) {
            if (e.isRetryable()) {
                throw new TransientKinesisException("Retryable client failure", e);
            }
            throw new RuntimeException("Not retryable client failure", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown kinesis failure, when trying to reach kinesis", e);
        }
    }
}

