/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.ClientGSIContext;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.namenode.ha.AbstractNNFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.HAProxyFactory;
import org.apache.hadoop.hdfs.server.namenode.ha.ReadOnly;
import org.apache.hadoop.io.retry.AtMostOnce;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.Idempotent;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ObserverRetryOnActiveException;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RpcInvocationHandler;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.util.BlockingThreadPoolExecutorService;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ObserverReadProxyProvider<T>
extends AbstractNNFailoverProxyProvider<T> {
    @VisibleForTesting
    static final Logger LOG = LoggerFactory.getLogger(ObserverReadProxyProvider.class);
    static final String AUTO_MSYNC_PERIOD_KEY_PREFIX = "dfs.client.failover.observer.auto-msync-period";
    static final long AUTO_MSYNC_PERIOD_DEFAULT = -1L;
    private final AlignmentContext alignmentContext;
    static final String OBSERVER_PROBE_RETRY_PERIOD_KEY = "dfs.client.failover.observer.probe.retry.period";
    static final long OBSERVER_PROBE_RETRY_PERIOD_DEFAULT = 600000L;
    static final String NAMENODE_HA_STATE_PROBE_TIMEOUT = "dfs.client.failover.namenode.ha-state.probe.timeout";
    static final long NAMENODE_HA_STATE_PROBE_TIMEOUT_DEFAULT = 0L;
    private final AbstractNNFailoverProxyProvider<T> failoverProxy;
    private final List<AbstractNNFailoverProxyProvider.NNProxyInfo<T>> nameNodeProxies;
    private final RetryPolicy observerRetryPolicy;
    private final FailoverProxyProvider.ProxyInfo<T> combinedProxy;
    private boolean observerReadEnabled;
    private final long autoMsyncPeriodMs;
    private volatile long lastMsyncTimeMs = -1L;
    private volatile boolean msynced = false;
    private int currentIndex = -1;
    private AbstractNNFailoverProxyProvider.NNProxyInfo<T> currentProxy;
    private volatile FailoverProxyProvider.ProxyInfo<T> lastProxy = null;
    private long observerProbeRetryPeriodMs;
    private long namenodeHAStateProbeTimeoutMs;
    private long lastObserverProbeTime;
    private final BlockingThreadPoolExecutorService nnProbingThreadPool;

    public ObserverReadProxyProvider(Configuration conf, URI uri, Class<T> xface, HAProxyFactory<T> factory) {
        this(conf, uri, xface, factory, new ConfiguredFailoverProxyProvider<T>(conf, uri, xface, factory));
    }

    public ObserverReadProxyProvider(Configuration conf, URI uri, Class<T> xface, HAProxyFactory<T> factory, AbstractNNFailoverProxyProvider<T> failoverProxy) {
        super(conf, uri, xface, factory);
        this.failoverProxy = failoverProxy;
        this.alignmentContext = new ClientGSIContext();
        factory.setAlignmentContext(this.alignmentContext);
        this.lastObserverProbeTime = 0L;
        this.observerRetryPolicy = RetryPolicies.failoverOnNetworkException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, (int)1);
        this.nameNodeProxies = this.getProxyAddresses(uri, "dfs.namenode.rpc-address");
        StringBuilder combinedInfo = new StringBuilder("[");
        for (int i = 0; i < this.nameNodeProxies.size(); ++i) {
            if (i > 0) {
                combinedInfo.append(",");
            }
            combinedInfo.append(this.nameNodeProxies.get((int)i).proxyInfo);
        }
        combinedInfo.append(']');
        Object wrappedProxy = Proxy.newProxyInstance(ObserverReadInvocationHandler.class.getClassLoader(), new Class[]{xface}, (InvocationHandler)((Object)new ObserverReadInvocationHandler()));
        this.combinedProxy = new FailoverProxyProvider.ProxyInfo(wrappedProxy, combinedInfo.toString());
        this.autoMsyncPeriodMs = conf.getTimeDuration("dfs.client.failover.observer.auto-msync-period." + uri.getHost(), -1L, TimeUnit.MILLISECONDS);
        this.observerProbeRetryPeriodMs = conf.getTimeDuration(OBSERVER_PROBE_RETRY_PERIOD_KEY, 600000L, TimeUnit.MILLISECONDS);
        this.namenodeHAStateProbeTimeoutMs = conf.getTimeDuration(NAMENODE_HA_STATE_PROBE_TIMEOUT, 0L, TimeUnit.MILLISECONDS);
        if (wrappedProxy instanceof ClientProtocol) {
            this.observerReadEnabled = true;
        } else {
            LOG.info("Disabling observer reads for {} because the requested proxy class does not implement {}", (Object)uri, (Object)ClientProtocol.class.getName());
            this.observerReadEnabled = false;
        }
        this.nnProbingThreadPool = BlockingThreadPoolExecutorService.newInstance((int)4, (int)128, (long)10L, (TimeUnit)TimeUnit.SECONDS, (String)"nn-ha-state-probing");
    }

    public AlignmentContext getAlignmentContext() {
        return this.alignmentContext;
    }

    public FailoverProxyProvider.ProxyInfo<T> getProxy() {
        return this.combinedProxy;
    }

    public void performFailover(T currentProxy) {
        this.failoverProxy.performFailover(currentProxy);
    }

    private static boolean isRead(Method method) {
        if (!method.isAnnotationPresent(ReadOnly.class)) {
            return false;
        }
        return !((ReadOnly[])method.getAnnotationsByType(ReadOnly.class))[0].activeOnly();
    }

    @VisibleForTesting
    void setObserverReadEnabled(boolean flag) {
        this.observerReadEnabled = flag;
    }

    @VisibleForTesting
    FailoverProxyProvider.ProxyInfo<T> getLastProxy() {
        return this.lastProxy;
    }

    private AbstractNNFailoverProxyProvider.NNProxyInfo<T> getCurrentProxy() {
        return this.changeProxy(null);
    }

    private synchronized AbstractNNFailoverProxyProvider.NNProxyInfo<T> changeProxy(AbstractNNFailoverProxyProvider.NNProxyInfo<T> initial) {
        if (this.currentProxy != initial) {
            return this.currentProxy;
        }
        this.currentIndex = (this.currentIndex + 1) % this.nameNodeProxies.size();
        this.currentProxy = this.createProxyIfNeeded(this.nameNodeProxies.get(this.currentIndex));
        this.currentProxy.setCachedState(this.getHAServiceStateWithTimeout(this.currentProxy));
        LOG.debug("Changed current proxy from {} to {}", (Object)(initial == null ? "none" : initial.proxyInfo), (Object)this.currentProxy.proxyInfo);
        return this.currentProxy;
    }

    HAServiceProtocol.HAServiceState getHAServiceStateWithTimeout(AbstractNNFailoverProxyProvider.NNProxyInfo<T> proxyInfo) {
        Callable<HAServiceProtocol.HAServiceState> getHAServiceStateTask = () -> this.getHAServiceState(proxyInfo);
        try {
            Future task = this.nnProbingThreadPool.submit(getHAServiceStateTask);
            return this.getHAServiceStateWithTimeout(proxyInfo, task);
        }
        catch (RejectedExecutionException e) {
            LOG.warn("Run out of threads to submit the request to query HA state. Ok to return null and we will fallback to use active NN to serve this request.");
            return null;
        }
    }

    HAServiceProtocol.HAServiceState getHAServiceStateWithTimeout(AbstractNNFailoverProxyProvider.NNProxyInfo<T> proxyInfo, Future<HAServiceProtocol.HAServiceState> task) {
        HAServiceProtocol.HAServiceState state = null;
        try {
            state = this.namenodeHAStateProbeTimeoutMs > 0L ? task.get(this.namenodeHAStateProbeTimeoutMs, TimeUnit.MILLISECONDS) : task.get();
            LOG.debug("HA State for {} is {}", (Object)proxyInfo.proxyInfo, (Object)state);
        }
        catch (TimeoutException e) {
            String msg = String.format("Cancel NN probe task due to timeout for %s", proxyInfo.proxyInfo);
            LOG.warn(msg, (Throwable)e);
            if (task != null) {
                task.cancel(true);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            String msg = String.format("Exception in NN probe task for %s", proxyInfo.proxyInfo);
            LOG.warn(msg, (Throwable)e);
        }
        return state;
    }

    private HAServiceProtocol.HAServiceState getHAServiceState(AbstractNNFailoverProxyProvider.NNProxyInfo<T> proxyInfo) {
        Throwable ioe;
        try {
            return this.getProxyAsClientProtocol(proxyInfo.proxy).getHAServiceState();
        }
        catch (RemoteException re) {
            if (re.unwrapRemoteException() instanceof StandbyException) {
                LOG.debug("NameNode {} threw StandbyException when fetching HAState", (Object)proxyInfo.getAddress());
                return HAServiceProtocol.HAServiceState.STANDBY;
            }
            ioe = re;
        }
        catch (IOException e) {
            ioe = e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Failed to connect to {} while fetching HAServiceState", (Object)proxyInfo.getAddress(), (Object)ioe);
        }
        return null;
    }

    private ClientProtocol getProxyAsClientProtocol(T proxy) {
        assert (proxy instanceof ClientProtocol) : "BUG: Attempted to use proxy of class " + proxy.getClass() + " as if it was a ClientProtocol.";
        return (ClientProtocol)proxy;
    }

    private synchronized void initializeMsync() throws IOException {
        if (this.msynced) {
            return;
        }
        this.getProxyAsClientProtocol(this.failoverProxy.getProxy().proxy).msync();
        this.msynced = true;
        this.lastMsyncTimeMs = Time.monotonicNow();
    }

    private boolean shouldFindObserver() {
        if (this.lastObserverProbeTime > 0L) {
            return Time.monotonicNow() - this.lastObserverProbeTime >= this.observerProbeRetryPeriodMs;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoMsyncIfNecessary() throws IOException {
        if (this.autoMsyncPeriodMs == 0L) {
            this.getProxyAsClientProtocol(this.failoverProxy.getProxy().proxy).msync();
        } else if (this.autoMsyncPeriodMs > 0L && Time.monotonicNow() - this.lastMsyncTimeMs > this.autoMsyncPeriodMs) {
            ObserverReadProxyProvider observerReadProxyProvider = this;
            synchronized (observerReadProxyProvider) {
                if (Time.monotonicNow() - this.lastMsyncTimeMs > this.autoMsyncPeriodMs) {
                    this.getProxyAsClientProtocol(this.failoverProxy.getProxy().proxy).msync();
                    this.lastMsyncTimeMs = Time.monotonicNow();
                }
            }
        }
    }

    public synchronized void close() throws IOException {
        for (FailoverProxyProvider.ProxyInfo proxyInfo : this.nameNodeProxies) {
            if (proxyInfo.proxy == null) continue;
            if (proxyInfo.proxy instanceof Closeable) {
                ((Closeable)proxyInfo.proxy).close();
            } else {
                RPC.stopProxy((Object)proxyInfo.proxy);
            }
            proxyInfo.proxy = null;
        }
        this.failoverProxy.close();
        this.nnProbingThreadPool.shutdown();
    }

    @Override
    public boolean useLogicalURI() {
        return this.failoverProxy.useLogicalURI();
    }

    private class ObserverReadInvocationHandler
    implements RpcInvocationHandler {
        private ObserverReadInvocationHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object retVal;
            ObserverReadProxyProvider.this.lastProxy = null;
            if (ObserverReadProxyProvider.this.observerReadEnabled && ObserverReadProxyProvider.this.shouldFindObserver() && ObserverReadProxyProvider.isRead(method)) {
                if (!ObserverReadProxyProvider.this.msynced) {
                    ObserverReadProxyProvider.this.initializeMsync();
                } else {
                    ObserverReadProxyProvider.this.autoMsyncIfNecessary();
                }
                int failedObserverCount = 0;
                int activeCount = 0;
                int standbyCount = 0;
                int unreachableCount = 0;
                for (int i = 0; i < ObserverReadProxyProvider.this.nameNodeProxies.size(); ++i) {
                    AbstractNNFailoverProxyProvider.NNProxyInfo current = ObserverReadProxyProvider.this.getCurrentProxy();
                    HAServiceProtocol.HAServiceState currState = current.getCachedState();
                    if (currState != HAServiceProtocol.HAServiceState.OBSERVER) {
                        if (currState == HAServiceProtocol.HAServiceState.ACTIVE) {
                            ++activeCount;
                        } else if (currState == HAServiceProtocol.HAServiceState.STANDBY) {
                            ++standbyCount;
                        } else if (currState == null) {
                            ++unreachableCount;
                        }
                        LOG.debug("Skipping proxy {} for {} because it is in state {}", new Object[]{current.proxyInfo, method.getName(), currState == null ? "unreachable" : currState});
                        ObserverReadProxyProvider.this.changeProxy(current);
                        continue;
                    }
                    LOG.debug("Attempting to service {} using proxy {}", (Object)method.getName(), (Object)current.proxyInfo);
                    try {
                        Object retVal2 = method.invoke(current.proxy, args);
                        ObserverReadProxyProvider.this.lastProxy = current;
                        LOG.debug("Invocation of {} using {} was successful", (Object)method.getName(), (Object)current.proxyInfo);
                        return retVal2;
                    }
                    catch (InvocationTargetException ite) {
                        RemoteException re;
                        IOException unwrapped;
                        if (!(ite.getCause() instanceof Exception)) {
                            throw ite.getCause();
                        }
                        Exception e = (Exception)ite.getCause();
                        if (e instanceof InterruptedIOException || e instanceof InterruptedException) {
                            LOG.warn("Invocation returned interrupted exception on [{}];", (Object)current.proxyInfo, (Object)e);
                            throw e;
                        }
                        if (e instanceof RemoteException && (unwrapped = (re = (RemoteException)((Object)e)).unwrapRemoteException(new Class[]{ObserverRetryOnActiveException.class})) instanceof ObserverRetryOnActiveException) {
                            LOG.debug("Encountered ObserverRetryOnActiveException from {}. Retry active namenode directly.", (Object)current.proxyInfo);
                            break;
                        }
                        RetryPolicy.RetryAction retryInfo = ObserverReadProxyProvider.this.observerRetryPolicy.shouldRetry(e, 0, 0, method.isAnnotationPresent(Idempotent.class) || method.isAnnotationPresent(AtMostOnce.class));
                        if (retryInfo.action == RetryPolicy.RetryAction.RetryDecision.FAIL) {
                            throw e;
                        }
                        LOG.warn("Invocation returned exception on [{}]; {} failure(s) so far", new Object[]{current.proxyInfo, ++failedObserverCount, e});
                        ObserverReadProxyProvider.this.changeProxy(current);
                    }
                }
                if (failedObserverCount > 0) {
                    LOG.warn("{} observers have failed for read request {}; also found {} standby, {} active, and {} unreachable. Falling back to active.", new Object[]{failedObserverCount, method.getName(), standbyCount, activeCount, unreachableCount});
                    ObserverReadProxyProvider.this.lastObserverProbeTime = 0L;
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Read falling back to active without observer read fail, is there no observer node running?");
                    }
                    ObserverReadProxyProvider.this.lastObserverProbeTime = Time.monotonicNow();
                }
            }
            LOG.debug("Using failoverProxy to service {}", (Object)method.getName());
            FailoverProxyProvider.ProxyInfo activeProxy = ObserverReadProxyProvider.this.failoverProxy.getProxy();
            try {
                retVal = method.invoke(activeProxy.proxy, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            ObserverReadProxyProvider.this.msynced = true;
            ObserverReadProxyProvider.this.lastMsyncTimeMs = Time.monotonicNow();
            ObserverReadProxyProvider.this.lastProxy = activeProxy;
            return retVal;
        }

        public void close() throws IOException {
        }

        public Client.ConnectionId getConnectionId() {
            return RPC.getConnectionIdForProxy((Object)(ObserverReadProxyProvider.this.observerReadEnabled ? ((ObserverReadProxyProvider)ObserverReadProxyProvider.this).getCurrentProxy().proxy : ((ObserverReadProxyProvider)ObserverReadProxyProvider.this).failoverProxy.getProxy().proxy));
        }
    }
}

