/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.run;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.HopVersionProvider;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.plugins.JarCache;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.hop.Hop;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.metadata.util.HopMetadataInstance;
import org.apache.hop.metadata.util.HopMetadataUtil;
import org.apache.hop.run.HopRunBase;
import picocli.CommandLine;

@CommandLine.Command(versionProvider=HopVersionProvider.class)
public class HopRun
extends HopRunBase
implements Runnable,
IHasHopMetadataProvider {
    public static void main(String[] args) {
        HopRun hopRun = new HopRun();
        try {
            hopRun.cmd = new CommandLine((Object)hopRun);
            if (args.length > 0) {
                hopRun.prepareInternalOptions(new CommandLine((Object)hopRun), args);
            }
            hopRun.applySystemProperties();
            HopEnvironment.init();
            hopRun.buildVariableSpace();
            HopLogStore.init();
            JarCache.getInstance().clear();
            hopRun.metadataProvider = HopMetadataUtil.getStandardHopMetadataProvider((IVariables)hopRun.variables);
            HopMetadataInstance.setMetadataProvider((MultiMetadataProvider)hopRun.metadataProvider);
            Hop.addMixinPlugins(hopRun.cmd, "run");
            CommandLine.ParseResult parseResult = hopRun.cmd.parseArgs(args);
            if (CommandLine.printHelpIfRequested((CommandLine.ParseResult)parseResult)) {
                System.exit(1);
            } else {
                hopRun.run();
                System.out.println("HopRun exit.");
                if (hopRun.isFinishedWithoutError()) {
                    System.exit(0);
                } else {
                    System.exit(1);
                }
            }
        }
        catch (CommandLine.ParameterException e) {
            System.err.println(e.getMessage());
            hopRun.cmd.usage(System.err);
            System.exit(9);
        }
        catch (CommandLine.ExecutionException e) {
            System.err.println("Error found during execution!");
            System.err.println(Const.getStackTracker((Throwable)e));
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("General error found, something went horribly wrong!");
            System.err.println(Const.getStackTracker((Throwable)e));
            System.exit(2);
        }
    }

    public void applySystemProperties() {
        if (this.systemProperties != null) {
            for (String parameter : this.systemProperties) {
                String value;
                String[] split = parameter.split("=", 2);
                String key = split.length > 0 ? split[0] : null;
                String string = value = split.length > 1 ? split[1] : null;
                if (!StringUtils.isNotEmpty((String)key) || !StringUtils.isNotEmpty((String)value)) continue;
                System.setProperty(key, value);
            }
        }
    }

    private void prepareInternalOptions(CommandLine cmd, String[] args) {
        for (String arg : args) {
            if (!arg.startsWith("-h") && !arg.startsWith("--help")) continue;
            return;
        }
        String[] helpArgs = new String[args.length + 1];
        System.arraycopy(args, 0, helpArgs, 0, args.length);
        helpArgs[args.length] = "-h";
        cmd.parseArgs(helpArgs);
    }
}

