/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public final class AzureServiceFuture<T>
extends ServiceFuture<T> {
    private AzureServiceFuture() {
    }

    public static <E> ServiceFuture<List<E>> fromPageResponse(Observable<ServiceResponse<Page<E>>> first, Func1<String, Observable<ServiceResponse<Page<E>>>> next, ListOperationCallback<E> callback) {
        AzureServiceFuture serviceCall = new AzureServiceFuture();
        PagingSubscriber subscriber = new PagingSubscriber(serviceCall, next, callback);
        serviceCall.setSubscription(first.single().subscribe(subscriber));
        return serviceCall;
    }

    public static <E, V> ServiceFuture<List<E>> fromHeaderPageResponse(Observable<ServiceResponseWithHeaders<Page<E>, V>> first, final Func1<String, Observable<ServiceResponseWithHeaders<Page<E>, V>>> next, ListOperationCallback<E> callback) {
        AzureServiceFuture serviceCall = new AzureServiceFuture();
        PagingSubscriber subscriber = new PagingSubscriber(serviceCall, new Func1<String, Observable<ServiceResponse<Page<E>>>>(){

            public Observable<ServiceResponse<Page<E>>> call(String s) {
                return ((Observable)next.call((Object)s)).map(new Func1<ServiceResponseWithHeaders<Page<E>, V>, ServiceResponse<Page<E>>>(){

                    public ServiceResponse<Page<E>> call(ServiceResponseWithHeaders<Page<E>, V> pageVServiceResponseWithHeaders) {
                        return pageVServiceResponseWithHeaders;
                    }
                });
            }
        }, callback);
        serviceCall.setSubscription(first.single().subscribe(subscriber));
        return serviceCall;
    }

    private static final class PagingSubscriber<E>
    extends Subscriber<ServiceResponse<Page<E>>> {
        private AzureServiceFuture<List<E>> serviceCall;
        private Func1<String, Observable<ServiceResponse<Page<E>>>> next;
        private ListOperationCallback<E> callback;
        private ServiceResponse<Page<E>> lastResponse;

        PagingSubscriber(AzureServiceFuture<List<E>> serviceCall, Func1<String, Observable<ServiceResponse<Page<E>>>> next, ListOperationCallback<E> callback) {
            this.serviceCall = serviceCall;
            this.next = next;
            this.callback = callback;
        }

        public void onCompleted() {
        }

        public void onError(Throwable e) {
            ((AzureServiceFuture)this.serviceCall).setException(e);
            if (this.callback != null) {
                this.callback.failure(e);
            }
        }

        public void onNext(ServiceResponse<Page<E>> serviceResponse) {
            this.lastResponse = serviceResponse;
            ListOperationCallback.PagingBehavior behavior = ListOperationCallback.PagingBehavior.CONTINUE;
            if (this.callback != null && ((behavior = this.callback.progress(((Page)serviceResponse.body()).items())) == ListOperationCallback.PagingBehavior.STOP || ((Page)serviceResponse.body()).nextPageLink() == null)) {
                this.callback.success();
            }
            if (behavior == ListOperationCallback.PagingBehavior.STOP || ((Page)serviceResponse.body()).nextPageLink() == null) {
                ((AzureServiceFuture)this.serviceCall).set(((Page)this.lastResponse.body()).items());
            } else {
                ((AzureServiceFuture)this.serviceCall).setSubscription(((Observable)this.next.call((Object)((Page)serviceResponse.body()).nextPageLink())).single().subscribe((Subscriber)this));
            }
        }
    }
}

