/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p60p1.com.google.api.client.http.apache;

import java.io.IOException;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.api.client.http.LowLevelHttpRequest;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.api.client.http.LowLevelHttpResponse;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.api.client.http.apache.ApacheHttpResponse;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.api.client.http.apache.ContentEntity;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.api.client.util.Preconditions;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

final class ApacheHttpRequest
extends LowLevelHttpRequest {
    private final HttpClient httpClient;
    private final HttpRequestBase request;

    ApacheHttpRequest(HttpClient httpClient, HttpRequestBase request) {
        this.httpClient = httpClient;
        this.request = request;
    }

    @Override
    public void addHeader(String name, String value) {
        this.request.addHeader(name, value);
    }

    @Override
    public void setTimeout(int connectTimeout, int readTimeout) throws IOException {
        HttpParams params = this.request.getParams();
        ConnManagerParams.setTimeout((HttpParams)params, (long)connectTimeout);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)connectTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)readTimeout);
    }

    @Override
    public LowLevelHttpResponse execute() throws IOException {
        if (this.getStreamingContent() != null) {
            Preconditions.checkState(this.request instanceof HttpEntityEnclosingRequest, "Apache HTTP client does not support %s requests with content.", this.request.getRequestLine().getMethod());
            ContentEntity entity = new ContentEntity(this.getContentLength(), this.getStreamingContent());
            entity.setContentEncoding(this.getContentEncoding());
            entity.setContentType(this.getContentType());
            if (this.getContentLength() == -1L) {
                entity.setChunked(true);
            }
            ((HttpEntityEnclosingRequest)this.request).setEntity((HttpEntity)entity);
        }
        return new ApacheHttpResponse(this.request, this.httpClient.execute((HttpUriRequest)this.request));
    }
}

