/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.JDProperties;
import java.sql.SQLException;

class SQLConversionSettings {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    public static final int DATE_FORMAT_JULIAN = 0;
    public static final int DATE_FORMAT_MDY = 1;
    public static final int DATE_FORMAT_DMY = 2;
    public static final int DATE_FORMAT_YMD = 3;
    public static final int DATE_FORMAT_USA = 4;
    public static final int DATE_FORMAT_ISO = 5;
    public static final int DATE_FORMAT_EUR = 6;
    public static final int DATE_FORMAT_JIS = 7;
    public static final int TIME_FORMAT_HMS = 0;
    public static final int TIME_FORMAT_USA = 1;
    public static final int TIME_FORMAT_ISO = 2;
    public static final int TIME_FORMAT_EUR = 3;
    public static final int TIME_FORMAT_JIS = 4;
    public static final int TIMESTAMP_FORMAT_ISO = 0;
    public static final int TIMESTAMP_FORMAT_IBMSQL = 1;
    private int dateFormat_;
    private String dateSeparator_;
    private String decimalSeparator_;
    private int maxFieldSize_;
    private int timeFormat_;
    private int timestampFormat_;
    private String timeSeparator_;
    private boolean useBigDecimal_;
    private int bidiStringType_;
    private boolean bidiImplicitReordering_;
    private boolean bidiNumericOrdering_;
    private boolean translateBoolean_;
    private static Object cachedConversionSettingsLock_ = new Object();
    private static SQLConversionSettings cachedConversionSettings_ = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SQLConversionSettings getConversionSettings(AS400JDBCConnection connection) throws SQLException {
        Object object = cachedConversionSettingsLock_;
        synchronized (object) {
            if (cachedConversionSettings_ != null && cachedConversionSettings_.matches(connection)) {
                return cachedConversionSettings_;
            }
            cachedConversionSettings_ = new SQLConversionSettings(connection);
            return cachedConversionSettings_;
        }
    }

    static SQLConversionSettings getConversionSettingsWithMaxFieldSize(SQLConversionSettings oldSettings, int maxFieldSize) {
        if (oldSettings.maxFieldSize_ == maxFieldSize) {
            return oldSettings;
        }
        return new SQLConversionSettings(oldSettings, maxFieldSize);
    }

    private SQLConversionSettings(AS400JDBCConnection connection) throws SQLException {
        JDProperties properties = connection.getProperties();
        this.dateFormat_ = properties.getIndex(3);
        this.dateSeparator_ = properties.getString(4);
        this.decimalSeparator_ = properties.getString(5);
        this.timeFormat_ = properties.getIndex(24);
        this.timestampFormat_ = properties.getIndex(87);
        this.timeSeparator_ = properties.getString(25);
        this.bidiStringType_ = this.getInt(properties.getString(42));
        this.bidiImplicitReordering_ = properties.getBoolean(60);
        this.bidiNumericOrdering_ = properties.getBoolean(61);
        if (this.dateSeparator_.equalsIgnoreCase("b")) {
            this.dateSeparator_ = " ";
        }
        if (this.timeSeparator_.equalsIgnoreCase("b")) {
            this.timeSeparator_ = " ";
        }
        this.maxFieldSize_ = 0;
        this.useBigDecimal_ = properties.getBoolean(37);
        this.translateBoolean_ = properties.getBoolean(71);
    }

    private SQLConversionSettings(SQLConversionSettings oldSettings, int maxFieldSize) {
        this.dateFormat_ = oldSettings.dateFormat_;
        this.dateSeparator_ = oldSettings.dateSeparator_;
        this.decimalSeparator_ = oldSettings.decimalSeparator_;
        this.timeFormat_ = oldSettings.timeFormat_;
        this.timeSeparator_ = oldSettings.timeSeparator_;
        this.timestampFormat_ = oldSettings.timestampFormat_;
        this.bidiStringType_ = oldSettings.bidiStringType_;
        this.bidiImplicitReordering_ = oldSettings.bidiImplicitReordering_;
        this.bidiNumericOrdering_ = oldSettings.bidiNumericOrdering_;
        this.dateSeparator_ = oldSettings.dateSeparator_;
        this.timeSeparator_ = oldSettings.timeSeparator_;
        this.maxFieldSize_ = maxFieldSize;
        this.useBigDecimal_ = oldSettings.useBigDecimal_;
        this.translateBoolean_ = oldSettings.translateBoolean_;
    }

    private boolean stringRefsEqual(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    private boolean matches(AS400JDBCConnection connection) throws SQLException {
        JDProperties properties = connection.getProperties();
        if (this.dateFormat_ != properties.getIndex(3)) {
            return false;
        }
        String dateSeparatorCompare = this.dateSeparator_;
        if (dateSeparatorCompare != null && dateSeparatorCompare == " ") {
            dateSeparatorCompare = "b";
        }
        if (!this.stringRefsEqual(dateSeparatorCompare, properties.getString(4))) {
            return false;
        }
        if (!this.stringRefsEqual(this.decimalSeparator_, properties.getString(5))) {
            return false;
        }
        if (this.timeFormat_ != properties.getIndex(24)) {
            return false;
        }
        String timeSeparatorCompare = this.timeSeparator_;
        if (timeSeparatorCompare != null && timeSeparatorCompare == " ") {
            timeSeparatorCompare = "b";
        }
        if (this.timestampFormat_ != properties.getIndex(87)) {
            return false;
        }
        if (!this.stringRefsEqual(timeSeparatorCompare, properties.getString(25))) {
            return false;
        }
        if (this.bidiStringType_ != this.getInt(properties.getString(42))) {
            return false;
        }
        if (this.bidiImplicitReordering_ != properties.getBoolean(60)) {
            return false;
        }
        if (this.bidiNumericOrdering_ != properties.getBoolean(61)) {
            return false;
        }
        if (this.maxFieldSize_ != 0) {
            return false;
        }
        if (this.useBigDecimal_ != properties.getBoolean(37)) {
            return false;
        }
        return this.translateBoolean_ == properties.getBoolean(71);
    }

    int getInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    int getBidiStringType() {
        return this.bidiStringType_;
    }

    boolean getBidiImplicitReordering() {
        return this.bidiImplicitReordering_;
    }

    boolean getBidiNumericOrdering() {
        return this.bidiNumericOrdering_;
    }

    boolean getTranslateBoolean() {
        return this.translateBoolean_;
    }

    int getDateFormat() {
        return this.dateFormat_;
    }

    String getDateSeparator() {
        return this.dateSeparator_;
    }

    String getDecimalSeparator() {
        return this.decimalSeparator_;
    }

    int getMaxFieldSize() {
        return this.maxFieldSize_;
    }

    int getTimeFormat() {
        return this.timeFormat_;
    }

    String getTimeSeparator() {
        return this.timeSeparator_;
    }

    int getTimestampFormat() {
        return this.timestampFormat_;
    }

    boolean useBigDecimal() {
        return this.useBigDecimal_;
    }
}

