/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ProxyException;
import com.ibm.as400.access.PxAcceptRepCV;
import com.ibm.as400.access.PxClientReadDaemon;
import com.ibm.as400.access.PxDSFactory;
import com.ibm.as400.access.PxRepCV;
import com.ibm.as400.access.PxReqCV;
import com.ibm.as400.access.PxSocketContainer;
import com.ibm.as400.access.PxSocketContainerAdapter;
import com.ibm.as400.access.RetryInputStream;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;

public abstract class PxClientConnectionAdapter {
    private static final String copyright = "Copyrixght (C) 1997-2000 International Business Machines Corporation and others.";
    private boolean closed_ = false;
    private InputStream input_ = null;
    private OutputStream output_ = null;
    private PxClientReadDaemon readDaemon_ = null;
    private PxSocketContainerAdapter socket_ = null;
    private SSLOptions sslOptions_ = null;
    boolean tunnel_ = false;
    private long clientId_ = -1L;
    private URL tunnelURL_ = null;
    private String localName = null;

    protected PxClientConnectionAdapter(String proxyServer, SSLOptions secure) {
        this.sslOptions_ = secure;
        this.open(proxyServer);
    }

    public void close() {
        if (!this.tunnel_) {
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, "Closing a connection to proxy server.");
            }
            this.readDaemon_.stopSafely();
            try {
                this.input_.close();
            }
            catch (IOException e) {
                if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                    Trace.log(2, e.getMessage(), (Throwable)e);
                }
                throw new ProxyException(2, (Throwable)e);
            }
            try {
                this.output_.close();
            }
            catch (IOException e) {
                if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                    Trace.log(2, e.getMessage(), (Throwable)e);
                }
                throw new ProxyException(2, (Throwable)e);
            }
            try {
                this.socket_.close();
            }
            catch (IOException e) {
                if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                    Trace.log(2, e.getMessage(), (Throwable)e);
                }
                throw new ProxyException(2, (Throwable)e);
            }
        }
        this.closed_ = true;
    }

    protected void finalize() throws Throwable {
        if (!this.closed_) {
            this.close();
        }
        super.finalize();
    }

    public PxDSFactory getFactory() {
        return this.readDaemon_.getFactory();
    }

    public void open(String proxyServer) {
        int colon;
        boolean secure;
        boolean bl = secure = this.sslOptions_ != null && this.sslOptions_.proxyEncryptionMode_ != 2;
        if (Trace.isTraceOn()) {
            Trace.log(6, "Opening a connection to proxy server " + proxyServer + " (secure=" + secure + ").");
        }
        this.localName = proxyServer;
        String protocolName = null;
        int port = -1;
        if (proxyServer.indexOf("://") > 0) {
            this.tunnel_ = true;
            this.localName = proxyServer.substring(proxyServer.indexOf(":") + 3);
            protocolName = proxyServer.substring(0, proxyServer.indexOf(":"));
        }
        if ((colon = this.localName.indexOf(58)) >= 0) {
            if (colon < this.localName.length() - 1) {
                port = Integer.parseInt(this.localName.substring(colon + 1));
            }
            this.localName = this.localName.substring(0, colon);
        }
        if (!this.tunnel_) {
            if (port < 0) {
                port = secure ? 3471 : 3470;
            }
            this.openTraditional(this.localName, port, secure);
        } else {
            this.openTunnel(protocolName, this.localName, port);
        }
    }

    void openTraditional(String name, int port, boolean secure) {
        try {
            if (secure) {
                Class<?> classPxSecureSocketContainer = Class.forName("com.ibm.as400.access.PxSecureSocketContainer");
                Class[] parameterTypes = new Class[]{"".getClass(), Integer.TYPE, Class.forName("com.ibm.as400.access.SSLOptions")};
                Constructor<?> constructor = classPxSecureSocketContainer.getConstructor(parameterTypes);
                Object[] initargs = new Object[]{name, port, this.sslOptions_};
                this.socket_ = (PxSocketContainerAdapter)constructor.newInstance(initargs);
            } else {
                this.socket_ = new PxSocketContainer(name, port);
            }
            this.output_ = new BufferedOutputStream(this.socket_.getOutputStream());
            this.input_ = new BufferedInputStream(new RetryInputStream(this.socket_.getInputStream()));
            this.readDaemon_ = new PxClientReadDaemon(this.input_);
            this.readDaemon_.start();
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, "Connection established.");
            }
        }
        catch (ClassNotFoundException e) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server (ClassNotFound", (Throwable)e);
            }
            throw new ProxyException(1, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server (NoSuchMethodException", (Throwable)e);
            }
            throw new ProxyException(1, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server (IllegalAccessException", (Throwable)e);
            }
            throw new ProxyException(1, (Throwable)e);
        }
        catch (IOException e) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server (openio", (Throwable)e);
            }
            throw new ProxyException(1, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server (IllegalArgumentException", (Throwable)e);
            }
            throw new ProxyException(1, (Throwable)e);
        }
        catch (InstantiationException e) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server (InstantiationException", (Throwable)e);
            }
            throw new ProxyException(1, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server (InvocationTargetException", (Throwable)e);
            }
            throw new ProxyException(1, (Throwable)e);
        }
    }

    void openTunnel(String protocol, String name, int port) {
        try {
            this.readDaemon_ = new PxClientReadDaemon();
            this.readDaemon_.register(new PxAcceptRepCV());
            this.tunnelURL_ = port < 0 ? new URL(protocol, name, "/servlet/com.ibm.as400.access.TunnelProxyServer") : new URL(protocol, name, port, "/servlet/com.ibm.as400.access.TunnelProxyServer");
        }
        catch (IOException e) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server", (Throwable)e);
            }
            throw new ProxyException(1, (Throwable)e);
        }
    }

    private URLConnection tunnelSend(PxReqCV request) {
        try {
            request.setClientId(this.clientId_);
            URLConnection connection_ = this.tunnelURL_.openConnection();
            connection_.setUseCaches(false);
            connection_.setDoOutput(true);
            connection_.setDoInput(true);
            connection_.setRequestProperty("Content-type", "application/octet-stream");
            connection_.setRequestProperty("Connection", "Keep-Alive");
            OutputStream connectionOut = connection_.getOutputStream();
            if (Trace.isTraceProxyOn()) {
                request.dump(Trace.getPrintWriter());
            }
            request.writeTo(connectionOut);
            connectionOut.flush();
            return connection_;
        }
        catch (Exception e) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server", (Throwable)e);
            }
            throw new ProxyException(1, (Throwable)e);
        }
    }

    Object tunnelReceive(long correlationId, URLConnection connection_) throws InvocationTargetException {
        try {
            InputStream connectionIn = connection_.getInputStream();
            try {
                PxRepCV reply = this.readDaemon_.getReply(correlationId, connectionIn);
                Object returnValue = reply.process();
                this.clientId_ = reply.getClientId();
                return returnValue;
            }
            catch (IOException e) {
                if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                    Trace.log(2, "Error when receiving reply from proxy server", (Throwable)e);
                }
                ProxyException px = new ProxyException(2, (Throwable)e);
                throw px;
            }
        }
        catch (InvocationTargetException ite) {
            throw ite;
        }
        catch (Exception e) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server", (Throwable)e);
            }
            ProxyException px = new ProxyException(1, (Throwable)e);
            throw px;
        }
    }

    private Object receive(long correlationId) throws InvocationTargetException {
        Object returnValue = null;
        try {
            PxRepCV reply = this.readDaemon_.getReply(correlationId);
            returnValue = reply.process();
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, this, "received " + returnValue);
            }
        }
        catch (IOException e) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when receiving reply from proxy server", (Throwable)e);
            }
            if (e instanceof NotSerializableException) {
                throw new ProxyException(4, (Throwable)e);
            }
            throw new ProxyException(2, (Throwable)e);
        }
        return returnValue;
    }

    protected synchronized void send(PxReqCV request) {
        if (!this.tunnel_) {
            if (Trace.isTraceProxyOn()) {
                request.dump(Trace.getPrintWriter());
            }
            try {
                request.writeTo(this.output_);
                this.output_.flush();
            }
            catch (IOException e) {
                if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                    Trace.log(2, e.getMessage(), (Throwable)e);
                }
                throw new ProxyException(2, (Throwable)e);
            }
        } else {
            URLConnection uRLConnection = this.tunnelSend(request);
        }
    }

    protected Object sendAndReceive(PxReqCV request) throws InvocationTargetException {
        if (!this.tunnel_) {
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, this, "Sending request with id " + request.getCorrelationId());
            }
            this.send(request);
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, this, "Receiving with id " + request.getCorrelationId());
            }
            return this.receive(request.getCorrelationId());
        }
        URLConnection connection_ = this.tunnelSend(request);
        Object o = this.tunnelReceive(request.getCorrelationId(), connection_);
        return o;
    }

    public String getSystemName() {
        return this.localName;
    }
}

