/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.LinkedList;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.BufferWithSubpartition;
import org.apache.flink.runtime.io.network.partition.DataBuffer;
import org.apache.flink.util.Preconditions;

public class HashBasedDataBuffer
implements DataBuffer {
    private final LinkedList<MemorySegment> freeSegments;
    private final BufferRecycler bufferRecycler;
    private final int numGuaranteedBuffers;
    private final ArrayDeque<BufferConsumer>[] buffers;
    private final int bufferSize;
    private long numTotalBytes;
    private long numTotalRecords;
    private boolean isFinished;
    private boolean isReleased;
    private final BufferBuilder[] builders;
    private int numBuffersOccupied;
    private int readOrderIndex;
    private final int[] subpartitionReadOrder;
    private long numTotalBytesRead;

    public HashBasedDataBuffer(LinkedList<MemorySegment> freeSegments, BufferRecycler bufferRecycler, int numSubpartitions, int bufferSize, int numGuaranteedBuffers, @Nullable int[] customReadOrder) {
        int subpartition;
        Preconditions.checkArgument((numGuaranteedBuffers > 0 ? 1 : 0) != 0, (Object)"No guaranteed buffers for sort.");
        this.freeSegments = (LinkedList)Preconditions.checkNotNull(freeSegments);
        this.bufferRecycler = (BufferRecycler)Preconditions.checkNotNull((Object)bufferRecycler);
        this.bufferSize = bufferSize;
        this.numGuaranteedBuffers = numGuaranteedBuffers;
        Preconditions.checkState((numGuaranteedBuffers <= freeSegments.size() ? 1 : 0) != 0, (Object)"Wrong number of free segments.");
        this.builders = new BufferBuilder[numSubpartitions];
        this.buffers = new ArrayDeque[numSubpartitions];
        for (subpartition = 0; subpartition < numSubpartitions; ++subpartition) {
            this.buffers[subpartition] = new ArrayDeque();
        }
        this.subpartitionReadOrder = new int[numSubpartitions];
        if (customReadOrder != null) {
            Preconditions.checkArgument((customReadOrder.length == numSubpartitions ? 1 : 0) != 0, (Object)"Illegal data read order.");
            System.arraycopy(customReadOrder, 0, this.subpartitionReadOrder, 0, numSubpartitions);
        } else {
            for (subpartition = 0; subpartition < numSubpartitions; ++subpartition) {
                this.subpartitionReadOrder[subpartition] = subpartition;
            }
        }
    }

    @Override
    public boolean append(ByteBuffer source, int targetSubpartition, Buffer.DataType dataType) throws IOException {
        Preconditions.checkArgument((boolean)source.hasRemaining(), (Object)"Cannot append empty data.");
        Preconditions.checkState((!this.isFinished ? 1 : 0) != 0, (Object)"Sort buffer is already finished.");
        Preconditions.checkState((!this.isReleased ? 1 : 0) != 0, (Object)"Sort buffer is already released.");
        int totalBytes = source.remaining();
        if (dataType.isBuffer()) {
            this.writeRecord(source, targetSubpartition);
        } else {
            this.writeEvent(source, targetSubpartition, dataType);
        }
        if (source.hasRemaining()) {
            return true;
        }
        ++this.numTotalRecords;
        this.numTotalBytes += (long)(totalBytes - source.remaining());
        return false;
    }

    private void writeEvent(ByteBuffer source, int targetSubpartition, Buffer.DataType dataType) {
        BufferBuilder builder = this.builders[targetSubpartition];
        if (builder != null) {
            builder.finish();
            builder.close();
            this.builders[targetSubpartition] = null;
        }
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)source.remaining());
        segment.put(0, source, segment.size());
        BufferConsumer consumer = new BufferConsumer(new NetworkBuffer(segment, FreeingBufferRecycler.INSTANCE, dataType), segment.size());
        this.buffers[targetSubpartition].add(consumer);
    }

    private void writeRecord(ByteBuffer source, int targetSubpartition) {
        int availableBytes;
        BufferBuilder builder = this.builders[targetSubpartition];
        int n = availableBytes = builder != null ? builder.getWritableBytes() : 0;
        if ((long)source.remaining() > (long)availableBytes + (long)(this.numGuaranteedBuffers - this.numBuffersOccupied) * (long)this.bufferSize) {
            return;
        }
        do {
            if (builder == null) {
                builder = new BufferBuilder(this.freeSegments.poll(), this.bufferRecycler);
                this.buffers[targetSubpartition].add(builder.createBufferConsumer());
                ++this.numBuffersOccupied;
                this.builders[targetSubpartition] = builder;
            }
            builder.append(source);
            if (!builder.isFull()) continue;
            builder.finish();
            builder.close();
            this.builders[targetSubpartition] = null;
            builder = null;
        } while (source.hasRemaining());
    }

    @Override
    public BufferWithSubpartition getNextBuffer(MemorySegment transitBuffer) {
        Preconditions.checkState((boolean)this.isFinished, (Object)"Sort buffer is not ready to be read.");
        Preconditions.checkState((!this.isReleased ? 1 : 0) != 0, (Object)"Sort buffer is already released.");
        BufferWithSubpartition buffer = null;
        if (!this.hasRemaining() || this.readOrderIndex >= this.subpartitionReadOrder.length) {
            return null;
        }
        int targetSubpartition = this.subpartitionReadOrder[this.readOrderIndex];
        while (buffer == null) {
            BufferConsumer consumer = this.buffers[targetSubpartition].poll();
            if (consumer != null) {
                buffer = new BufferWithSubpartition(consumer.build(), targetSubpartition);
                this.numBuffersOccupied -= buffer.getBuffer().isBuffer() ? 1 : 0;
                this.numTotalBytesRead += (long)buffer.getBuffer().readableBytes();
                consumer.close();
                continue;
            }
            if (++this.readOrderIndex >= this.subpartitionReadOrder.length) break;
            targetSubpartition = this.subpartitionReadOrder[this.readOrderIndex];
        }
        return buffer;
    }

    @Override
    public long numTotalRecords() {
        return this.numTotalRecords;
    }

    @Override
    public long numTotalBytes() {
        return this.numTotalBytes;
    }

    @Override
    public boolean hasRemaining() {
        return this.numTotalBytesRead < this.numTotalBytes;
    }

    @Override
    public void finish() {
        Preconditions.checkState((!this.isFinished ? 1 : 0) != 0, (Object)"DataBuffer is already finished.");
        this.isFinished = true;
        for (int subpartition = 0; subpartition < this.builders.length; ++subpartition) {
            BufferBuilder builder = this.builders[subpartition];
            if (builder == null) continue;
            builder.finish();
            builder.close();
            this.builders[subpartition] = null;
        }
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public void release() {
        if (this.isReleased) {
            return;
        }
        this.isReleased = true;
        for (int subpartition = 0; subpartition < this.builders.length; ++subpartition) {
            BufferBuilder builder = this.builders[subpartition];
            if (builder == null) continue;
            builder.close();
            this.builders[subpartition] = null;
        }
        for (ArrayDeque<BufferConsumer> buffer : this.buffers) {
            BufferConsumer consumer = buffer.poll();
            while (consumer != null) {
                consumer.close();
                consumer = buffer.poll();
            }
        }
    }

    @Override
    public boolean isReleased() {
        return this.isReleased;
    }
}

