/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.accumulators;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.util.SerializedValue;

public class AccumulatorSnapshot
implements Serializable {
    private static final long serialVersionUID = 42L;
    private final JobID jobID;
    private final ExecutionAttemptID executionAttemptID;
    private final SerializedValue<Map<String, Accumulator<?, ?>>> userAccumulators;

    public AccumulatorSnapshot(JobID jobID, ExecutionAttemptID executionAttemptID, Map<String, Accumulator<?, ?>> userAccumulators) throws IOException {
        this.jobID = jobID;
        this.executionAttemptID = executionAttemptID;
        this.userAccumulators = new SerializedValue(userAccumulators);
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public ExecutionAttemptID getExecutionAttemptID() {
        return this.executionAttemptID;
    }

    public Map<String, Accumulator<?, ?>> deserializeUserAccumulators(ClassLoader classLoader) throws IOException, ClassNotFoundException {
        return (Map)this.userAccumulators.deserializeValue(classLoader);
    }
}

