/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.common;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.common.TeamRootInfo;
import com.dropbox.core.v2.common.UserRootInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class RootInfo {
    @Nonnull
    protected final String rootNamespaceId;
    @Nonnull
    protected final String homeNamespaceId;

    public RootInfo(@Nonnull String rootNamespaceId, @Nonnull String homeNamespaceId) {
        if (rootNamespaceId == null) {
            throw new IllegalArgumentException("Required value for 'rootNamespaceId' is null");
        }
        if (!Pattern.matches("[-_0-9a-zA-Z:]+", rootNamespaceId)) {
            throw new IllegalArgumentException("String 'rootNamespaceId' does not match pattern");
        }
        this.rootNamespaceId = rootNamespaceId;
        if (homeNamespaceId == null) {
            throw new IllegalArgumentException("Required value for 'homeNamespaceId' is null");
        }
        if (!Pattern.matches("[-_0-9a-zA-Z:]+", homeNamespaceId)) {
            throw new IllegalArgumentException("String 'homeNamespaceId' does not match pattern");
        }
        this.homeNamespaceId = homeNamespaceId;
    }

    @Nonnull
    public String getRootNamespaceId() {
        return this.rootNamespaceId;
    }

    @Nonnull
    public String getHomeNamespaceId() {
        return this.homeNamespaceId;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.rootNamespaceId, this.homeNamespaceId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            RootInfo other = (RootInfo)obj;
            return !(this.rootNamespaceId != other.rootNamespaceId && !this.rootNamespaceId.equals(other.rootNamespaceId) || this.homeNamespaceId != other.homeNamespaceId && !this.homeNamespaceId.equals(other.homeNamespaceId));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends StructSerializer<RootInfo> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(RootInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (value instanceof TeamRootInfo) {
                TeamRootInfo.Serializer.INSTANCE.serialize((TeamRootInfo)value, g, collapse);
                return;
            }
            if (value instanceof UserRootInfo) {
                UserRootInfo.Serializer.INSTANCE.serialize((UserRootInfo)value, g, collapse);
                return;
            }
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("root_namespace_id");
            StoneSerializers.string().serialize(value.rootNamespaceId, g);
            g.writeFieldName("home_namespace_id");
            StoneSerializers.string().serialize(value.homeNamespaceId, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public RootInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            RootInfo value;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
                if ("".equals(tag)) {
                    tag = null;
                }
            }
            if (tag == null) {
                String f_rootNamespaceId = null;
                String f_homeNamespaceId = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("root_namespace_id".equals(field)) {
                        f_rootNamespaceId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("home_namespace_id".equals(field)) {
                        f_homeNamespaceId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_rootNamespaceId == null) {
                    throw new JsonParseException(p, "Required field \"root_namespace_id\" missing.");
                }
                if (f_homeNamespaceId == null) {
                    throw new JsonParseException(p, "Required field \"home_namespace_id\" missing.");
                }
                value = new RootInfo(f_rootNamespaceId, f_homeNamespaceId);
            } else if ("".equals(tag)) {
                value = INSTANCE.deserialize(p, true);
            } else if ("team".equals(tag)) {
                value = TeamRootInfo.Serializer.INSTANCE.deserialize(p, true);
            } else if ("user".equals(tag)) {
                value = UserRootInfo.Serializer.INSTANCE.deserialize(p, true);
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

