/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.util;

import io.github.spannm.jackcess.Column;
import io.github.spannm.jackcess.Cursor;
import io.github.spannm.jackcess.CursorBuilder;
import io.github.spannm.jackcess.Database;
import io.github.spannm.jackcess.Row;
import io.github.spannm.jackcess.impl.ByteUtil;
import io.github.spannm.jackcess.util.ExportFilter;
import io.github.spannm.jackcess.util.SimpleExportFilter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class ExportUtil {
    public static final String DEFAULT_DELIMITER = ",";
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    public static final String DEFAULT_FILE_EXT = "csv";

    private ExportUtil() {
    }

    public static void exportAll(Database db, File dir) throws IOException {
        ExportUtil.exportAll(db, dir, DEFAULT_FILE_EXT);
    }

    public static void exportAll(Database db, File dir, String ext) throws IOException {
        for (String tableName : db.getTableNames()) {
            ExportUtil.exportFile(db, tableName, new File(dir, tableName + "." + ext), false, DEFAULT_DELIMITER, '\"', SimpleExportFilter.INSTANCE);
        }
    }

    public static void exportAll(Database db, File dir, String ext, boolean header) throws IOException {
        for (String tableName : db.getTableNames()) {
            ExportUtil.exportFile(db, tableName, new File(dir, tableName + "." + ext), header, DEFAULT_DELIMITER, '\"', SimpleExportFilter.INSTANCE);
        }
    }

    public static void exportAll(Database db, File dir, String ext, boolean header, String delim, char quote, ExportFilter filter) throws IOException {
        for (String tableName : db.getTableNames()) {
            ExportUtil.exportFile(db, tableName, new File(dir, tableName + "." + ext), header, delim, quote, filter);
        }
    }

    public static void exportFile(Database db, String tableName, File f) throws IOException {
        ExportUtil.exportFile(db, tableName, f, false, DEFAULT_DELIMITER, '\"', SimpleExportFilter.INSTANCE);
    }

    public static void exportFile(Database db, String tableName, File f, boolean header, String delim, char quote, ExportFilter filter) throws IOException {
        try (BufferedWriter out = new BufferedWriter(new FileWriter(f));){
            ExportUtil.exportWriter(db, tableName, out, header, delim, quote, filter);
        }
    }

    public static void exportWriter(Database db, String tableName, BufferedWriter out) throws IOException {
        ExportUtil.exportWriter(db, tableName, out, false, DEFAULT_DELIMITER, '\"', SimpleExportFilter.INSTANCE);
    }

    public static void exportWriter(Database db, String tableName, BufferedWriter out, boolean header, String delim, char quote, ExportFilter filter) throws IOException {
        ExportUtil.exportWriter(CursorBuilder.createCursor(db.getTable(tableName)), out, header, delim, quote, filter);
    }

    public static void exportWriter(Cursor cursor, BufferedWriter out, boolean header, String delim, char quote, ExportFilter filter) throws IOException {
        Row row;
        String delimiter = delim == null ? DEFAULT_DELIMITER : delim;
        Pattern needsQuotePattern = Pattern.compile("(?:" + Pattern.quote(delimiter) + ")|(?:" + Pattern.quote("" + quote) + ")|(?:[\n\r])");
        List<? extends Column> origCols = cursor.getTable().getColumns();
        List<Column> columns = new ArrayList<Column>(origCols);
        columns = filter.filterColumns(columns);
        HashSet<String> columnNames = null;
        if (!origCols.equals(columns)) {
            columnNames = new HashSet<String>();
            for (Column c : columns) {
                columnNames.add(c.getName());
            }
        }
        if (header) {
            Iterator<Column> iter = columns.iterator();
            while (iter.hasNext()) {
                ExportUtil.writeValue(out, iter.next().getName(), quote, needsQuotePattern);
                if (!iter.hasNext()) continue;
                out.write(delimiter);
            }
            out.newLine();
        }
        Object[] unfilteredRowData = new Object[columns.size()];
        while ((row = cursor.getNextRow(columnNames)) != null) {
            for (int i = 0; i < columns.size(); ++i) {
                unfilteredRowData[i] = columns.get(i).getRowValue(row);
            }
            Object[] rowData = filter.filterRow(unfilteredRowData);
            if (rowData == null) continue;
            for (int i = 0; i < columns.size(); ++i) {
                Object obj = rowData[i];
                if (obj != null) {
                    String value = null;
                    value = obj instanceof byte[] ? ByteUtil.toHexString((byte[])obj) : String.valueOf(rowData[i]);
                    ExportUtil.writeValue(out, value, quote, needsQuotePattern);
                }
                if (i >= columns.size() - 1) continue;
                out.write(delimiter);
            }
            out.newLine();
        }
        out.flush();
    }

    private static void writeValue(BufferedWriter out, String value, char quote, Pattern needsQuotePattern) throws IOException {
        if (!needsQuotePattern.matcher(value).find()) {
            out.write(value);
            return;
        }
        out.write(quote);
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == quote) {
                out.write(quote);
            }
            out.write(c);
        }
        out.write(quote);
    }

    public static class Builder {
        private Database mdb;
        private String mtableName;
        private String mext = "csv";
        private Cursor mcursor;
        private String mdelim = ",";
        private char mquote = (char)34;
        private ExportFilter mfilter = SimpleExportFilter.INSTANCE;
        private boolean mheader;

        public Builder(Database _db) {
            this(_db, null);
        }

        public Builder(Database _db, String _tableName) {
            this.mdb = _db;
            this.mtableName = _tableName;
        }

        public Builder(Cursor _cursor) {
            this.mcursor = _cursor;
        }

        public Builder withDatabase(Database _db) {
            this.mdb = _db;
            return this;
        }

        public Builder withTableName(String _tableName) {
            this.mtableName = _tableName;
            return this;
        }

        public Builder withCursor(Cursor _cursor) {
            this.mcursor = _cursor;
            return this;
        }

        public Builder withDelimiter(String _delim) {
            this.mdelim = _delim;
            return this;
        }

        public Builder withQuote(char _quote) {
            this.mquote = _quote;
            return this;
        }

        public Builder withFilter(ExportFilter _filter) {
            this.mfilter = _filter;
            return this;
        }

        public Builder withHeader(boolean _header) {
            this.mheader = _header;
            return this;
        }

        public Builder withFileNameExtension(String _ext) {
            this.mext = _ext;
            return this;
        }

        public void exportAll(File dir) throws IOException {
            ExportUtil.exportAll(this.mdb, dir, this.mext, this.mheader, this.mdelim, this.mquote, this.mfilter);
        }

        public void exportFile(File f) throws IOException {
            ExportUtil.exportFile(this.mdb, this.mtableName, f, this.mheader, this.mdelim, this.mquote, this.mfilter);
        }

        public void exportWriter(BufferedWriter writer) throws IOException {
            if (this.mcursor != null) {
                ExportUtil.exportWriter(this.mcursor, writer, this.mheader, this.mdelim, this.mquote, this.mfilter);
            } else {
                ExportUtil.exportWriter(this.mdb, this.mtableName, writer, this.mheader, this.mdelim, this.mquote, this.mfilter);
            }
        }
    }
}

