/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hop.core.Const;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;

abstract class BaseRowSet
implements Comparable<IRowSet>,
IRowSet {
    protected IRowMeta rowMeta;
    protected AtomicBoolean done = new AtomicBoolean(false);
    protected volatile String originTransformName;
    protected AtomicInteger originTransformCopy = new AtomicInteger(0);
    protected volatile String destinationTransformName;
    protected AtomicInteger destinationTransformCopy = new AtomicInteger(0);
    protected volatile String remoteHopServerName;
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    @Override
    public int compareTo(IRowSet rowSet) {
        String target;
        this.lock.readLock().lock();
        try {
            target = this.remoteHopServerName + "." + this.destinationTransformName + "." + this.destinationTransformCopy.intValue();
        }
        finally {
            this.lock.readLock().unlock();
        }
        String comp = rowSet.getRemoteHopServerName() + "." + rowSet.getDestinationTransformName() + "." + rowSet.getDestinationTransformCopy();
        return target.compareTo(comp);
    }

    public boolean equals(BaseRowSet rowSet) {
        return this.compareTo(rowSet) == 0;
    }

    @Override
    public abstract boolean putRow(IRowMeta var1, Object[] var2);

    @Override
    public abstract boolean putRowWait(IRowMeta var1, Object[] var2, long var3, TimeUnit var5);

    @Override
    public abstract Object[] getRow();

    @Override
    public abstract Object[] getRowImmediate();

    @Override
    public abstract Object[] getRowWait(long var1, TimeUnit var3);

    @Override
    public void setDone() {
        this.done.set(true);
    }

    @Override
    public boolean isDone() {
        return this.done.get();
    }

    @Override
    public String getOriginTransformName() {
        return this.originTransformName;
    }

    @Override
    public int getOriginTransformCopy() {
        return this.originTransformCopy.get();
    }

    @Override
    public String getDestinationTransformName() {
        return this.destinationTransformName;
    }

    @Override
    public int getDestinationTransformCopy() {
        return this.destinationTransformCopy.get();
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public abstract int size();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadNameFromToCopy(String from, int fromCopy, String to, int toCopy) {
        this.lock.writeLock().lock();
        try {
            this.originTransformName = from;
            this.originTransformCopy.set(fromCopy);
            this.destinationTransformName = to;
            this.destinationTransformCopy.set(toCopy);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String toString() {
        StringBuilder str;
        this.lock.readLock().lock();
        try {
            str = new StringBuilder(Const.NVL(this.originTransformName, "?")).append(".").append(this.originTransformCopy).append(" - ").append(Const.NVL(this.destinationTransformName, "?")).append(".").append(this.destinationTransformCopy);
            if (!Utils.isEmpty(this.remoteHopServerName)) {
                str.append(" (").append(this.remoteHopServerName).append(")");
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return str.toString();
    }

    @Override
    public IRowMeta getRowMeta() {
        return this.rowMeta;
    }

    @Override
    public void setRowMeta(IRowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    @Override
    public String getRemoteHopServerName() {
        return this.remoteHopServerName;
    }

    @Override
    public void setRemoteHopServerName(String remoteHopServerName) {
        this.remoteHopServerName = remoteHopServerName;
    }

    @Override
    public boolean isBlocking() {
        return false;
    }
}

