/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.xp;

import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.www.HopServer;

@ExtensionPoint(id="HopServerCalculateFilenameExtensionPoint", extensionPointId="HopServerCalculateFilename", description="Resolves configuration filename specified relative to the given project")
public class HopServerCalculateFilenameExtensionPoint
implements IExtensionPoint<HopServer> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, HopServer hopServer) throws HopException {
        if (hopServer.getParameters() == null || hopServer.getParameters().size() == 1) {
            try {
                String alternativeFilename;
                String filename = variables.resolve((String)hopServer.getParameters().get(0));
                FileObject fileObject = HopVfs.getFileObject((String)filename);
                if (!fileObject.exists() && (fileObject = HopVfs.getFileObject((String)(alternativeFilename = variables.resolve("${PROJECT_HOME}/" + filename)))).exists()) {
                    hopServer.setRealFilename(alternativeFilename);
                    log.logBasic("Relative path filename specified: " + hopServer.getRealFilename());
                }
            }
            catch (Exception e) {
                throw new HopException("Error calculating configuration filename (relative to project)", (Throwable)e);
            }
        }
    }
}

